/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.bukkit.commands;

import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.bukkit.TCPerm;
import com.khorn.terraincontrol.bukkit.TXPlugin;
import com.khorn.terraincontrol.bukkit.commands.BaseCommand;
import com.khorn.terraincontrol.bukkit.util.WorldHelper;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class CheckCommand
extends BaseCommand {
    public CheckCommand(TXPlugin _plugin) {
        super(_plugin);
        this.name = "check";
        this.perm = TCPerm.CMD_CHECK.node;
        this.usage = "check World_Name";
        this.workOnConsole = true;
    }

    @Override
    public boolean onCommand(CommandSender sender, List<String> args) {
        LocalWorld localWorld;
        World world;
        Location location = this.getLocation(sender);
        if (location == null) {
            if (args.isEmpty()) {
                sender.sendMessage(ERROR_COLOR + "You need to specify the world name.");
                return true;
            }
            world = Bukkit.getWorld((String)args.get(0));
            if (world == null) {
                sender.sendMessage(ERROR_COLOR + "The world \"" + args.get(0) + "\" doesn't exist.");
                return true;
            }
        } else {
            world = location.getWorld();
        }
        if ((localWorld = WorldHelper.toLocalWorld(world)) == null) {
            sender.sendMessage(ERROR_COLOR + "OpenTerrainGenerator" + " is not enabled for the world \"" + world.getName() + "\".");
        } else {
            sender.sendMessage(MESSAGE_COLOR + "OpenTerrainGenerator" + " is enabled for the world " + VALUE_COLOR + "\"" + world.getName() + "\"" + MESSAGE_COLOR + ".");
        }
        return true;
    }
}

