/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.bukkit;

import com.khorn.terraincontrol.LocalMaterialData;
import com.khorn.terraincontrol.LocalWorld;
import com.khorn.terraincontrol.TerrainControlEngine;
import com.khorn.terraincontrol.bukkit.BukkitLogger;
import com.khorn.terraincontrol.bukkit.BukkitMaterialData;
import com.khorn.terraincontrol.bukkit.TXPlugin;
import com.khorn.terraincontrol.exception.InvalidConfigException;
import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.server.v1_10_R1.Block;

public class BukkitEngine
extends TerrainControlEngine {
    private final TXPlugin plugin;

    public BukkitEngine(TXPlugin plugin) {
        super(new BukkitLogger(plugin.getLogger()));
        this.plugin = plugin;
    }

    @Override
    public LocalWorld getWorld(String name) {
        return this.plugin.worlds.get(name);
    }

    @Override
    public File getTCDataFolder() {
        return this.plugin.getDataFolder();
    }

    @Override
    public File getGlobalObjectsDirectory() {
        return new File(this.getTCDataFolder(), "GlobalObjects");
    }

    @Override
    public LocalMaterialData readMaterial(String input) throws InvalidConfigException {
        Block block = Block.getByName((String)input);
        if (block != null) {
            return BukkitMaterialData.ofMinecraftBlock(block);
        }
        try {
            return this.getMaterial0(input);
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigException("Unknown material: " + input);
        }
    }

    private LocalMaterialData getMaterial0(String input) throws NumberFormatException, InvalidConfigException {
        DefaultMaterial defaultMaterial;
        Block block;
        String blockName = input;
        int blockData = -1;
        int splitIndex = input.lastIndexOf(":");
        if (splitIndex == -1) {
            splitIndex = input.lastIndexOf(".");
        }
        if (splitIndex != -1) {
            blockName = input.substring(0, splitIndex);
            blockData = Integer.parseInt(input.substring(splitIndex + 1));
        }
        if ((block = Block.getByName((String)blockName)) == null && (defaultMaterial = DefaultMaterial.getMaterial(blockName)) != DefaultMaterial.UNKNOWN_BLOCK) {
            block = Block.getById((int)defaultMaterial.id);
        }
        if (block != null) {
            if (blockData == -1) {
                return BukkitMaterialData.ofMinecraftBlock(block);
            }
            try {
                return BukkitMaterialData.ofMinecraftBlockData(block.fromLegacyData(blockData));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigException("Illegal block data for the block type, cannot use " + input);
            }
        }
        throw new InvalidConfigException("Unknown material: " + input);
    }

    @Override
    public LocalMaterialData toLocalMaterialData(DefaultMaterial defaultMaterial, int blockData) {
        return BukkitMaterialData.ofDefaultMaterial(defaultMaterial, blockData);
    }

    @Override
    public ArrayList<LocalWorld> getAllWorlds() {
        ArrayList<LocalWorld> worlds = new ArrayList<LocalWorld>();
        worlds.addAll(this.plugin.worlds.values());
        return worlds;
    }

    @Override
    public LocalWorld getUnloadedWorld(String name) {
        return null;
    }
}

