/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.openglider.common.helper;

import gr8pefish.openglider.api.item.IGlider;
import gr8pefish.openglider.api.lib.GliderHelper;
import gr8pefish.openglider.common.config.ConfigHandler;
import gr8pefish.openglider.common.network.PacketHandler;
import gr8pefish.openglider.common.network.PacketUpdateGliderDamage;
import gr8pefish.openglider.common.wind.WindHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class OpenGliderPlayerHelper {
    public static void updatePosition(EntityPlayer player) {
        if (OpenGliderPlayerHelper.shouldBeGliding(player)) {
            ItemStack glider = GliderHelper.getGlider(player);
            if (OpenGliderPlayerHelper.isValidGlider(glider)) {
                if (player.field_70181_x < 0.0) {
                    double verticalSpeed;
                    double horizontalSpeed;
                    IGlider iGlider = (IGlider)glider.func_77973_b();
                    if (!player.func_70093_af()) {
                        horizontalSpeed = iGlider.getHorizontalFlightSpeed();
                        verticalSpeed = iGlider.getVerticalFlightSpeed();
                    } else {
                        horizontalSpeed = iGlider.getShiftHorizontalFlightSpeed();
                        verticalSpeed = iGlider.getShiftVerticalFlightSpeed();
                    }
                    WindHelper.applyWind(player, glider);
                    player.field_70181_x *= verticalSpeed;
                    double x = Math.cos(Math.toRadians(player.field_70177_z + 90.0f)) * horizontalSpeed;
                    double z = Math.sin(Math.toRadians(player.field_70177_z + 90.0f)) * horizontalSpeed;
                    player.field_70159_w += x;
                    player.field_70179_y += z;
                    player.field_70143_R = 0.0f;
                }
                if (player.field_70170_p.field_72995_K) {
                    player.field_184619_aG = 0.0f;
                    player.field_70721_aZ = 0.0f;
                }
                if (ConfigHandler.durabilityEnabled && !player.field_70170_p.field_72995_K && player.field_70170_p.field_73012_v.nextInt(ConfigHandler.durabilityTimeframe) == 0) {
                    PacketHandler.HANDLER.sendTo((IMessage)new PacketUpdateGliderDamage(), (EntityPlayerMP)player);
                    glider.func_77972_a(ConfigHandler.durabilityPerUse, (EntityLivingBase)player);
                    if (((IGlider)glider.func_77973_b()).isBroken(glider)) {
                        GliderHelper.setIsGliderDeployed(player, false);
                    }
                }
            } else {
                GliderHelper.setIsGliderDeployed(player, false);
            }
        }
    }

    private static void playWindSound(EntityPlayer player) {
        float f = MathHelper.func_76133_a((double)(player.field_70159_w * player.field_70159_w + player.field_70179_y * player.field_70179_y + player.field_70181_x * player.field_70181_x));
        float f1 = f / 2.0f;
        float volume = (double)f >= 0.01 ? MathHelper.func_76131_a((float)(f1 * f1), (float)0.0f, (float)1.0f) : 0.0f;
        float pitch = volume > 0.8f ? 1.0f + (volume - 0.8f) : 1.0f;
        player.func_184185_a(SoundEvents.field_189426_aK, volume, pitch);
    }

    public static boolean shouldBeGliding(EntityPlayer player) {
        if (player == null || player.field_70128_L) {
            return false;
        }
        return !player.field_70122_E && !player.func_70090_H();
    }

    private static boolean isValidGlider(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IGlider && !((IGlider)stack.func_77973_b()).isBroken(stack);
    }

    public static ItemStack getGlider(EntityPlayer player) {
        return player.func_184614_ca();
    }
}

