/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.openglider.common.event;

import gr8pefish.openglider.api.capabilities.CapabilityHelper;
import gr8pefish.openglider.api.lib.GliderHelper;
import gr8pefish.openglider.common.capabilities.GliderCapabilityImplementation;
import gr8pefish.openglider.common.helper.OpenGliderPlayerHelper;
import gr8pefish.openglider.common.network.PacketHandler;
import gr8pefish.openglider.common.network.PacketUpdateClientTarget;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ServerEventHandler {
    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer && !CapabilityHelper.hasGliderCapability((EntityPlayer)event.getObject())) {
            event.addCapability(GliderCapabilityImplementation.Provider.NAME, (ICapabilityProvider)new GliderCapabilityImplementation.Provider());
        }
    }

    @SubscribeEvent
    public void onPlayerCloning(PlayerEvent.Clone event) {
        if (CapabilityHelper.hasGliderCapability(event.getOriginal())) {
            NBTTagCompound gliderData = (NBTTagCompound)CapabilityHelper.getGliderCapability(event.getOriginal()).serializeNBT();
            CapabilityHelper.getGliderCapability(event.getEntityPlayer()).deserializeNBT((NBTBase)gliderData);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (GliderHelper.getIsGliderDeployed(event.player)) {
            OpenGliderPlayerHelper.updatePosition(event.player);
        }
    }

    @SubscribeEvent
    public void onTrack(PlayerEvent.StartTracking event) {
        EntityPlayer targetPlayer;
        EntityPlayer tracker = event.getEntityPlayer();
        Entity targetEntity = event.getTarget();
        if (targetEntity instanceof EntityPlayerMP && CapabilityHelper.hasGliderCapability(targetPlayer = (EntityPlayer)targetEntity)) {
            if (GliderHelper.getIsGliderDeployed(targetPlayer)) {
                PacketHandler.HANDLER.sendTo((IMessage)new PacketUpdateClientTarget(targetPlayer, true), (EntityPlayerMP)tracker);
            } else {
                PacketHandler.HANDLER.sendTo((IMessage)new PacketUpdateClientTarget(targetPlayer, false), (EntityPlayerMP)tracker);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        this.syncGlidingCapability(event.player);
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.syncGlidingCapability(event.player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.syncGlidingCapability(event.player);
    }

    private void syncGlidingCapability(EntityPlayer player) {
        CapabilityHelper.getGliderCapability(player).sync((EntityPlayerMP)player);
    }
}

