/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.lumberjack.items;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.doubledoordev.lumberjack.Lumberjack;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ItemLumberAxe
extends ItemAxe {
    private static Field efficiencyOnProperMaterialField = ItemTool.class.getDeclaredFields()[1];
    private static Field damageVsEntityField = ItemTool.class.getDeclaredFields()[2];
    private static Field attackSpeedField = ItemTool.class.getDeclaredFields()[3];
    private static List<ItemLumberAxe> lumberAxes;
    private static List<String> toolMaterials;
    public final String materialName;
    public final boolean fromAxe;

    public static List<ItemLumberAxe> getLumberAxes() {
        return ImmutableList.copyOf(lumberAxes);
    }

    public static List<String> getUsedToolMaterials() {
        return ImmutableList.copyOf(toolMaterials);
    }

    public static boolean usedMaterial(Item.ToolMaterial m) {
        return toolMaterials.contains(ItemLumberAxe.normalizeName(m));
    }

    @Nullable
    public static ItemStack getRepairStack(Item.ToolMaterial m) {
        try {
            return m.getRepairItemStack();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Lumberjack.getLogger().error("ArrayIndexOutOfBoundsException when registering a lumberaxe. This is a known issue, currently being investigated. {}", new Object[]{m});
            return null;
        }
    }

    public static String normalizeName(Item.ToolMaterial toolMaterial) {
        String name = toolMaterial.name().toLowerCase().replaceAll("tools?|materials?|(battle)?(sword|axe|hoe|pick(axe)?|shovel|hammer)", "").replaceAll("[_|:]+", " ").trim();
        if (name.indexOf(32) != -1) {
            name = name.substring(name.indexOf(32) + 1);
        }
        return name.replaceAll(" ", "");
    }

    public ItemLumberAxe(Item.ToolMaterial m, ItemAxe axe) throws IllegalAccessException {
        this(m, true);
        Lumberjack.getLogger().info("New LumberAxe {} ({}) From axe {}", new Object[]{this.field_77862_b, this.materialName, axe.getRegistryName()});
        this.setProperty(efficiencyOnProperMaterialField, axe);
        this.setProperty(damageVsEntityField, axe);
        this.setProperty(attackSpeedField, axe);
    }

    public ItemLumberAxe(Item.ToolMaterial m) {
        this(m, false);
        Lumberjack.getLogger().info("New LumberAxe {} ({}) From Material", new Object[]{this.field_77862_b, this.materialName});
    }

    private ItemLumberAxe(Item.ToolMaterial toolMaterial, boolean fromAxe) {
        super(toolMaterial, 5.0f + 2.5f * toolMaterial.func_78000_c(), -3.6f + 0.05f * toolMaterial.func_77998_b());
        this.fromAxe = fromAxe;
        this.materialName = ItemLumberAxe.normalizeName(toolMaterial);
        this.func_77655_b("lumberaxe" + Character.toUpperCase(this.materialName.charAt(0)) + this.materialName.substring(1));
        toolMaterials.add(this.materialName);
        ItemStack repairStack = ItemLumberAxe.getRepairStack(toolMaterial);
        if (repairStack != null && repairStack.func_77973_b() != null) {
            int[] ids;
            if (repairStack.func_77960_j() != 0) {
                Lumberjack.getLogger().info("LumberAxe {}({}) has a metadata based repair material. It might not be possible to repair in anvils. Blame vanilla.", new Object[]{this.materialName, toolMaterial});
            }
            if ((ids = OreDictionary.getOreIDs((ItemStack)repairStack)).length == 0) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)this, new Object[]{"XX", "SX", "SX", Character.valueOf('S'), "stickWood", Character.valueOf('X'), repairStack}).setMirrored(true));
            } else {
                for (int id : ids) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)this, new Object[]{"XX", "SX", "SX", Character.valueOf('S'), "stickWood", Character.valueOf('X'), OreDictionary.getOreName((int)id)}).setMirrored(true));
                }
            }
        } else {
            Lumberjack.getLogger().info("LumberAxe {} without recipe! Ask the mod author of {} for a ToolMaterial repairStack OR use D3Core's materials.json file to set it yourself.", new Object[]{this.materialName, toolMaterial});
        }
        this.setRegistryName("lumberjack", this.materialName + "_lumberaxe");
        GameRegistry.register((IForgeRegistryEntry)this);
        lumberAxes.add(this);
    }

    private void setProperty(Field field, ItemAxe axe) {
        try {
            field.set((Object)this, field.get(axe));
        }
        catch (Exception e) {
            Lumberjack.getLogger().error("Something went wrong trying to hack in the right damage/speed values of the " + this.field_77862_b + " axe.", (Throwable)e);
        }
    }

    public boolean func_179218_a(@Nullable ItemStack itemStack, @Nullable World world, IBlockState state, @Nullable BlockPos blockPos, @Nullable EntityLivingBase entityLivingBase) {
        return itemStack != null && world != null && blockPos != null && entityLivingBase != null && (Material.field_151584_j.equals(state.func_185904_a()) || super.func_179218_a(itemStack, world, state, blockPos, entityLivingBase));
    }

    static {
        efficiencyOnProperMaterialField.setAccessible(true);
        damageVsEntityField.setAccessible(true);
        attackSpeedField.setAccessible(true);
        lumberAxes = new ArrayList<ItemLumberAxe>();
        toolMaterials = new ArrayList<String>();
    }
}

