/*
 * Decompiled with CFR 0.152.
 */
package gaia.items;

import gaia.Gaia;
import gaia.entity.EntityGaiaEggInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ItemGaiaSpawnEgg
extends Item {
    private static Map<Integer, String> idToName = new HashMap<Integer, String>();
    public static Map<Integer, EntityGaiaEggInfo> idToEgg = new HashMap<Integer, EntityGaiaEggInfo>();
    private static Map<Integer, Class<? extends EntityLiving>> idToClass = new HashMap<Integer, Class<? extends EntityLiving>>();
    private static Map<Class<? extends EntityLiving>, Integer> classToID = new HashMap<Class<? extends EntityLiving>, Integer>();

    public static void registerEntityEgg(Class<? extends EntityLiving> entityClass, int entityID, int primaryColor, int secondaryColor) {
        Integer id = entityID;
        idToClass.put(id, entityClass);
        classToID.put(entityClass, id);
        idToEgg.put(id, new EntityGaiaEggInfo(entityID, primaryColor, secondaryColor));
        idToName.put(id, EntityList.func_188430_a(entityClass));
    }

    public static Entity spawnCreature(World world, int entityID, double posX, double posY, double posZ) {
        Integer id = entityID;
        if (!idToEgg.containsKey(id)) {
            return null;
        }
        EntityLiving entity = null;
        try {
            Class<? extends EntityLiving> exception = idToClass.get(id);
            if (exception != null) {
                entity = exception.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception var11) {
            var11.printStackTrace();
        }
        if (entity != null) {
            entity.func_70012_b(posX, posY, posZ, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entity.field_70759_as = entity.field_70177_z;
            entity.field_70761_aq = entity.field_70177_z;
            entity.func_180482_a(world.func_175649_E(new BlockPos((Entity)entity)), (IEntityLivingData)null);
            world.func_72838_d((Entity)entity);
            entity.func_70642_aH();
        }
        return entity;
    }

    public static int entityID(Class<? extends EntityLiving> entityClass) {
        Integer result = classToID.get(entityClass);
        return null == result ? -1 : result;
    }

    public ItemGaiaSpawnEgg(String name) {
        this.func_77627_a(true);
        this.func_77637_a(Gaia.tabGaia);
        this.func_77655_b(name);
    }

    public String func_77653_i(ItemStack istack) {
        String ownName = ("" + I18n.func_74838_a((String)(this.func_77658_a() + ".name"))).trim();
        String mobName = idToName.get(istack.func_77952_i());
        if (mobName != null) {
            ownName = ownName + " " + I18n.func_74838_a((String)("entity." + mobName + ".name"));
        }
        return ownName;
    }

    public String MobName(ItemStack istack) {
        return idToName.get(istack.func_77952_i());
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack istack, int renderPass) {
        EntityGaiaEggInfo EntityGaiaEggInfo2 = idToEgg.get(istack.func_77952_i());
        return EntityGaiaEggInfo2 != null ? (renderPass == 0 ? EntityGaiaEggInfo2.primaryColor : EntityGaiaEggInfo2.secondaryColor) : 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public static IItemColor getItemColor() {
        return new IItemColor(){

            public int func_186726_a(ItemStack stack, int pass) {
                EntityGaiaEggInfo EntityGaiaEggInfo2 = idToEgg.get(stack.func_77952_i());
                return EntityGaiaEggInfo2 != null ? (pass == 0 ? EntityGaiaEggInfo2.primaryColor : EntityGaiaEggInfo2.secondaryColor) : 0xFFFFFF;
            }
        };
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Entity entity;
        TileEntity tileentity;
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (iblockstate.func_177230_c() == Blocks.field_150474_ac && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityMobSpawner) {
            MobSpawnerBaseLogic mobspawnerbaselogic = ((TileEntityMobSpawner)tileentity).func_145881_a();
            mobspawnerbaselogic.func_98272_a(this.MobName(stack));
            tileentity.func_70296_d();
            worldIn.func_184138_a(pos, iblockstate, iblockstate, 3);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return EnumActionResult.SUCCESS;
        }
        pos = pos.func_177972_a(facing);
        double d0 = 0.0;
        if (facing == EnumFacing.UP && iblockstate.func_177230_c() instanceof BlockFence) {
            d0 = 0.5;
        }
        if ((entity = ItemGaiaSpawnEgg.spawnCreature(worldIn, stack.func_77952_i(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + d0, (double)pos.func_177952_p() + 0.5)) != null) {
            if (entity instanceof EntityLivingBase && stack.func_82837_s()) {
                entity.func_96094_a(stack.func_82833_r());
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack istack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)istack);
        }
        RayTraceResult mop = this.func_77621_a(world, player, true);
        if (mop == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)istack);
        }
        if (mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            Entity entity;
            int posX = mop.func_178782_a().func_177958_n();
            int posY = mop.func_178782_a().func_177958_n();
            int posZ = mop.func_178782_a().func_177958_n();
            BlockPos pos = mop.func_178782_a();
            if (!world.canMineBlockBody(player, pos) || !player.func_175151_a(pos, mop.field_178784_b, istack)) {
                return new ActionResult(EnumActionResult.PASS, (Object)istack);
            }
            IBlockState b = world.func_180495_p(pos);
            if (b.func_185904_a() == Material.field_151586_h && (entity = ItemGaiaSpawnEgg.spawnCreature(world, istack.func_77952_i(), posX, posY, posZ)) != null) {
                if (entity instanceof EntityLiving && istack.func_82837_s()) {
                    ((EntityLiving)entity).func_96094_a(istack.func_82833_r());
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    --istack.field_77994_a;
                }
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)istack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item p_150895_1_, CreativeTabs p_150895_2_, List p_150895_3_) {
        for (EntityGaiaEggInfo info : idToEgg.values()) {
            p_150895_3_.add(new ItemStack(p_150895_1_, 1, info.spawnedID));
        }
    }
}

