/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileBase;
import gaia.entity.monster.EntityGaiaArachne;
import gaia.init.GaiaItems;
import gaia.init.Sounds;
import gaia.items.ItemShard;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGaiaWitch
extends EntityMobHostileBase
implements IRangedAttackMob {
    private int spawn;
    private static final UUID MODIFIER_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier MODIFIER = new AttributeModifier(MODIFIER_UUID, "Drinking speed penalty", -0.25, 0).func_111168_a(false);
    private static final DataParameter<Boolean> IS_AGGRESSIVE = EntityDataManager.func_187226_a(EntityWitch.class, (DataSerializer)DataSerializers.field_187198_h);
    private int witchAttackTimer;

    public EntityGaiaWitch(World par1World) {
        super(par1World);
        this.field_70728_aV = EntityAttributes.experienceValue2;
        this.field_70138_W = 1.0f;
        this.spawn = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, EntityAttributes.attackSpeed2, 60, 10.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.maxHealth2);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(EntityAttributes.followrange);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(EntityAttributes.moveSpeed2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.attackDamage2);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(EntityAttributes.rateArmor2);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (damage > EntityAttributes.baseDefense2) {
            damage = EntityAttributes.baseDefense2;
        }
        return super.func_70097_a(source, damage);
    }

    public void func_70653_a(Entity entityIn, float strenght, double xRatio, double zRatio) {
        super.knockBack(entityIn, strenght, xRatio, zRatio, EntityAttributes.knockback2);
    }

    public void setAggressive(boolean aggressive) {
        this.func_184212_Q().func_187227_b(IS_AGGRESSIVE, (Object)aggressive);
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_AGGRESSIVE);
    }

    public boolean isAIEnabled() {
        return true;
    }

    public void func_70636_d() {
        this.beaconMonster(MobEffects.field_76429_m, 300, 1, 6);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.8;
        }
        if (this.field_70159_w > 0.0 || this.field_70181_x > 0.0 || this.field_70179_y > 0.0) {
            for (int var5 = 0; var5 < 2; ++var5) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.func_110143_aJ() < EntityAttributes.maxHealth2 * 0.75f && this.func_110143_aJ() > 0.0f && this.spawn == 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)12);
            if (!this.field_70170_p.field_72995_K) {
                EntitySpider spawnMob = new EntitySpider(this.field_70170_p);
                spawnMob.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                spawnMob.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)spawnMob)), (IEntityLivingData)null);
                this.field_70170_p.func_72838_d((Entity)spawnMob);
            }
            this.spawn = 1;
        }
        if (this.func_110143_aJ() < EntityAttributes.maxHealth2 * 0.25f && this.func_110143_aJ() > 0.0f && this.spawn == 1) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)12);
            if (!this.field_70170_p.field_72995_K) {
                EntitySpider spawnMob = new EntitySpider(this.field_70170_p);
                spawnMob.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                spawnMob.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)spawnMob)), (IEntityLivingData)null);
                this.field_70170_p.func_72838_d((Entity)spawnMob);
            }
            this.spawn = 2;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isDrinkingPotion()) {
                if (this.witchAttackTimer-- <= 0) {
                    List list;
                    this.setAggressive(false);
                    ItemStack itemstack = this.func_184614_ca();
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, null);
                    if (itemstack != null && itemstack.func_77973_b() == Items.field_151068_bn && (list = PotionUtils.func_185189_a((ItemStack)itemstack)) != null) {
                        for (PotionEffect potioneffect : list) {
                            this.func_70690_d(new PotionEffect(potioneffect));
                        }
                    }
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(MODIFIER);
                }
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.PropWeapon, 1, 0));
                PotionType potiontype = null;
                if (this.field_70146_Z.nextFloat() < 0.15f && this.func_70055_a(Material.field_151586_h) && !this.func_70644_a(MobEffects.field_76427_o)) {
                    potiontype = PotionTypes.field_185248_t;
                } else if (this.field_70146_Z.nextFloat() < 0.15f && (this.func_70027_ad() || this.func_189748_bU() != null && this.func_189748_bU().func_76347_k()) && !this.func_70644_a(MobEffects.field_76426_n)) {
                    potiontype = PotionTypes.field_185241_m;
                } else if (this.field_70146_Z.nextFloat() < 0.05f && this.func_110143_aJ() < this.func_110138_aP()) {
                    potiontype = PotionTypes.field_185250_v;
                } else if (this.field_70146_Z.nextFloat() < 0.5f && this.func_70638_az() != null && !this.func_70644_a(MobEffects.field_76424_c) && this.func_70638_az().func_70068_e((Entity)this) > 121.0) {
                    potiontype = PotionTypes.field_185243_o;
                }
                if (potiontype != null) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potiontype));
                    this.witchAttackTimer = this.func_184614_ca().func_77988_m();
                    this.setAggressive(true);
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187922_gv, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                    IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
                    iattributeinstance.func_111124_b(MODIFIER);
                    iattributeinstance.func_111121_a(MODIFIER);
                }
            }
            if (this.field_70146_Z.nextFloat() < 7.5E-4f) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)15);
            }
        }
        super.func_70636_d();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_AGGRESSIVE, (Object)false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 12) {
            this.spawnParticles(EnumParticleTypes.EXPLOSION_NORMAL);
        } else if (id == 15) {
            for (int i = 0; i < this.field_70146_Z.nextInt(35) + 10; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)0.13f, this.func_174813_aQ().field_72337_e + 0.5 + this.field_70146_Z.nextGaussian() * (double)0.13f, this.field_70161_v + this.field_70146_Z.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EnumParticleTypes particleType) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    protected float func_70672_c(DamageSource source, float damage) {
        damage = super.func_70672_c(source, damage);
        if (source.func_76346_g() == this) {
            damage = 0.0f;
        }
        if (source.func_82725_o()) {
            damage = (float)((double)damage * 0.15);
        }
        return damage;
    }

    public float func_70689_ay() {
        float speed = super.func_70689_ay();
        if (this.isDrinkingPotion()) {
            speed *= 0.75f;
        }
        return speed;
    }

    public void func_82196_d(EntityLivingBase target, float p_82196_2_) {
        if (!this.isDrinkingPotion()) {
            double d0 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
            double d1 = target.field_70165_t + target.field_70159_w - this.field_70165_t;
            double d2 = d0 - this.field_70163_u;
            double d3 = target.field_70161_v + target.field_70179_y - this.field_70161_v;
            float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3));
            PotionType potiontype = PotionTypes.field_185252_x;
            if (f >= 8.0f && !target.func_70644_a(MobEffects.field_76421_d)) {
                potiontype = PotionTypes.field_185246_r;
            } else if (target.func_110143_aJ() >= 8.0f && !target.func_70644_a(MobEffects.field_76436_u)) {
                potiontype = PotionTypes.field_185254_z;
            } else if (f <= 3.0f && !target.func_70644_a(MobEffects.field_76437_t) && this.field_70146_Z.nextFloat() < 0.25f) {
                potiontype = PotionTypes.field_185226_I;
            }
            EntityPotion entitypotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)potiontype));
            entitypotion.field_70125_A -= -20.0f;
            entitypotion.func_70186_c(d1, d2 + (double)(f * 0.2f), d3, 0.75f, 8.0f);
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
            this.field_70170_p.func_72838_d((Entity)entitypotion);
        }
    }

    public void beaconMonster(Potion effect, int duration, int power, int range) {
        if (!this.field_70170_p.field_72995_K) {
            double d0 = range;
            int k = (int)this.field_70165_t;
            int l = (int)this.field_70163_u;
            int i1 = (int)this.field_70161_v;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).func_186662_g(d0).func_72321_a(0.0, 0.0, 0.0);
            List moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
            for (EntityLivingBase mob : moblist) {
                if (mob instanceof EntityGaiaArachne) continue;
                if (mob instanceof EntitySpider) {
                    mob.func_70690_d(new PotionEffect(effect, duration, power, true, true));
                    continue;
                }
                if (!(mob instanceof EntityCaveSpider)) continue;
                mob.func_70690_d(new PotionEffect(effect, duration, power, true, true));
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return Sounds.aggressive_say;
    }

    protected SoundEvent func_184601_bQ() {
        return Sounds.aggressive_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return Sounds.aggressive_death;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(Sounds.none, 1.0f, 1.0f);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        this.func_70628_a(wasRecentlyHit, lootingModifier);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186432_n;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            int var3 = this.field_70146_Z.nextInt(3 + lootingModifier);
            for (int var4 = 0; var4 < var3; ++var4) {
                this.func_145779_a(GaiaItems.FoodNetherWart, 1);
            }
            int var11 = this.field_70146_Z.nextInt(3) + 1;
            for (int var12 = 0; var12 < var11; ++var12) {
                ItemShard.Drop_Nugget((Entity)this, 1);
            }
            if (GaiaConfig.AdditionalOre) {
                int var13 = this.field_70146_Z.nextInt(3) + 1;
                for (int var14 = 0; var14 < var13; ++var14) {
                    ItemShard.Drop_Nugget((Entity)this, 5);
                }
            }
            if (this.field_70146_Z.nextInt(EntityAttributes.rateraredrop) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                switch (this.field_70146_Z.nextInt(3)) {
                    case 0: {
                        this.func_145779_a(GaiaItems.BoxGold, 1);
                        break;
                    }
                    case 1: {
                        this.func_145779_a(GaiaItems.BagBook, 1);
                        break;
                    }
                    case 2: {
                        this.func_145779_a(GaiaItems.MiscBook, 1);
                    }
                }
            }
        }
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.PropWeapon, 1, 0));
        return livingdata;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(potioneffectIn);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_70601_bi() {
        return this.field_70163_u > 60.0 && super.func_70601_bi();
    }
}

