/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.monster;

import gaia.GaiaConfig;
import gaia.entity.EntityAttributes;
import gaia.entity.EntityMobHostileBase;
import gaia.entity.ai.Ranged;
import gaia.init.GaiaItems;
import gaia.init.Sounds;
import gaia.items.ItemShard;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGaiaShaman
extends EntityMobHostileBase
implements IRangedAttackMob {
    private EntityAIAttackRanged aiArrowAttack = new EntityAIAttackRanged((IRangedAttackMob)this, EntityAttributes.attackSpeed2, 20, 60, 15.0f);
    private EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, EntityAttributes.attackSpeed2, true);
    private int switchHealth;
    private int spawn;

    public EntityGaiaShaman(World worldIn) {
        super(worldIn);
        this.field_70728_aV = EntityAttributes.experienceValue2;
        this.field_70138_W = 1.0f;
        this.switchHealth = 0;
        this.spawn = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)EntityAttributes.maxHealth2);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(EntityAttributes.followrange);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(EntityAttributes.moveSpeed2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)EntityAttributes.attackDamage2);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(EntityAttributes.rateArmor2);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (damage > EntityAttributes.baseDefense2) {
            damage = EntityAttributes.baseDefense2;
        }
        return super.func_70097_a(source, damage);
    }

    public void func_70653_a(Entity entityIn, float strenght, double xRatio, double zRatio) {
        super.knockBack(entityIn, strenght, xRatio, zRatio, EntityAttributes.knockback2);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        Ranged.magic(target, (EntityLivingBase)this, distanceFactor);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int byte0 = 0;
                int byte1 = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    byte0 = 5;
                    byte1 = 10;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    byte0 = 10;
                    byte1 = 20;
                }
                if (byte0 > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, byte0 * 20, 0));
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76437_t, byte1 * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean isAIEnabled() {
        return true;
    }

    public boolean func_70687_e(PotionEffect par1PotionEffect) {
        return par1PotionEffect.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(par1PotionEffect);
    }

    public void func_70636_d() {
        EntityZombie spawnMob;
        this.beaconMonster(MobEffects.field_76429_m, 300, 1, 6);
        if (this.func_110143_aJ() < EntityAttributes.maxHealth2 * 0.75f && this.switchHealth == 0) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiAttackOnCollide);
            this.switchHealth = 1;
        }
        if (this.func_110143_aJ() > EntityAttributes.maxHealth2 * 0.75f && this.switchHealth == 1) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiArrowAttack);
            this.switchHealth = 0;
        }
        if (this.func_110143_aJ() < EntityAttributes.maxHealth2 * 0.75f && this.func_110143_aJ() > 0.0f && this.spawn == 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)12);
            if (!this.field_70170_p.field_72995_K) {
                spawnMob = new EntityZombie(this.field_70170_p);
                spawnMob.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                spawnMob.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)spawnMob)), (IEntityLivingData)null);
                spawnMob.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Blocks.field_150423_aK));
                this.field_70170_p.func_72838_d((Entity)spawnMob);
            }
            this.spawn = 1;
        }
        if (this.func_110143_aJ() < EntityAttributes.maxHealth2 * 0.25f && this.func_110143_aJ() > 0.0f && this.spawn == 1) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)12);
            if (!this.field_70170_p.field_72995_K) {
                spawnMob = new EntityZombie(this.field_70170_p);
                spawnMob.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                spawnMob.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)spawnMob)), (IEntityLivingData)null);
                spawnMob.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Blocks.field_150423_aK));
                this.field_70170_p.func_72838_d((Entity)spawnMob);
            }
            this.spawn = 2;
        }
        super.func_70636_d();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 12) {
            this.spawnParticles(EnumParticleTypes.EXPLOSION_NORMAL);
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EnumParticleTypes particleType) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    public void beaconMonster(Potion effect, int duration, int power, int range) {
        if (!this.field_70170_p.field_72995_K) {
            double d0 = range;
            int k = (int)this.field_70165_t;
            int l = (int)this.field_70163_u;
            int i1 = (int)this.field_70161_v;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)k, (double)l, (double)i1, (double)(k + 1), (double)(l + 1), (double)(i1 + 1)).func_186662_g(d0).func_72321_a(0.0, 0.0, 0.0);
            List moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
            for (EntityLivingBase mob : moblist) {
                if (mob instanceof EntityGaiaShaman) continue;
                if (mob instanceof EntityZombie) {
                    mob.func_70690_d(new PotionEffect(effect, duration, power, true, true));
                    continue;
                }
                if (!(mob instanceof EntitySkeleton)) continue;
                mob.func_70690_d(new PotionEffect(effect, duration, power, true, true));
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return Sounds.aggressive_say;
    }

    protected SoundEvent func_184601_bQ() {
        return Sounds.aggressive_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return Sounds.aggressive_death;
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        this.func_70628_a(wasRecentlyHit, lootingModifier);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186432_n;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        if (wasRecentlyHit) {
            int var3 = this.field_70146_Z.nextInt(3 + lootingModifier);
            for (int var4 = 0; var4 < var3; ++var4) {
                this.func_145779_a(GaiaItems.FoodRottenHeart, 1);
            }
            int var11 = this.field_70146_Z.nextInt(3) + 1;
            for (int var12 = 0; var12 < var11; ++var12) {
                ItemShard.Drop_Nugget((Entity)this, 1);
            }
            if (GaiaConfig.AdditionalOre) {
                int var13 = this.field_70146_Z.nextInt(3) + 1;
                for (int var14 = 0; var14 < var13; ++var14) {
                    ItemShard.Drop_Nugget((Entity)this, 5);
                }
            }
            if (this.field_70146_Z.nextInt(EntityAttributes.rateraredrop) == 0 || this.field_70146_Z.nextInt(1 + lootingModifier) > 0) {
                switch (this.field_70146_Z.nextInt(3)) {
                    case 0: {
                        this.func_145779_a(GaiaItems.BoxGold, 1);
                        break;
                    }
                    case 1: {
                        this.func_145779_a(GaiaItems.BagBook, 1);
                        break;
                    }
                    case 2: {
                        this.func_145779_a(GaiaItems.MiscBook, 1);
                    }
                }
            }
        }
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiArrowAttack);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.PropWeapon, 1, 0));
        this.func_180483_b(difficulty);
        return livingdata;
    }

    public boolean func_70601_bi() {
        return this.field_70163_u > 60.0 && super.func_70601_bi();
    }
}

