/*
 * Decompiled with CFR 0.152.
 */
package gaia.block;

import gaia.Gaia;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSpawnGuard
extends Block {
    protected static final AxisAlignedBB Down_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.06f, 1.0);
    protected static final AxisAlignedBB Up_BOX = new AxisAlignedBB(0.0, (double)0.94f, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB North_BOX = new AxisAlignedBB(0.0, 0.0, (double)0.94f, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB South_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.06f);
    protected static final AxisAlignedBB West_BOX = new AxisAlignedBB((double)0.94f, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB East_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.06f, 1.0, 1.0);
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);

    public BlockSpawnGuard() {
        super(Material.field_151580_n);
        this.func_149713_g(0);
        this.func_149711_c(0.0f);
        this.func_149752_b(6.0f);
        this.func_149663_c("GrimoireOfGaia.SpawnGuard");
        this.func_149647_a(Gaia.tabGaia);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumType.North)));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(TextFormatting.YELLOW + I18n.func_74838_a((String)"text.GrimoireOfGaia.grimoireofgaia.desc"));
        tooltip.add(I18n.func_74837_a((String)"block.GrimoireOfGaia.SpawnGuard.desc", (Object[])new Object[]{8}));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int meta = this.func_176201_c(state);
        if (meta < 4) {
            return Down_BOX;
        }
        if (8 > meta && meta > 3) {
            return Up_BOX;
        }
        switch (meta) {
            case 8: {
                return North_BOX;
            }
            case 9: {
                return South_BOX;
            }
            case 10: {
                return West_BOX;
            }
            case 11: {
                return East_BOX;
            }
        }
        return Down_BOX;
    }

    public IBlockState func_176203_a(int meta) {
        EnumType constant = EnumType.getConstant(meta);
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)constant));
    }

    public int func_176201_c(IBlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b((IProperty)TYPE));
        return type.getID();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        int ID = 0;
        int face = facing.func_176745_a();
        ID = facing == EnumFacing.UP ? MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3 : (facing == EnumFacing.DOWN ? (MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) + 4 : face + 6);
        return this.func_176203_a(ID);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public static enum EnumType implements IStringSerializable
    {
        North(0, "north"),
        South(1, "south"),
        West(2, "west"),
        East(3, "east"),
        Up_North(4, "u_north"),
        Up_South(5, "u_south"),
        Up_West(6, "u_west"),
        Up_East(7, "u_east"),
        Vertical_North(8, "v_north"),
        Vertical_South(9, "v_south"),
        Vertical_West(10, "v_west"),
        Vertical_East(11, "v_east");

        private int ID;
        private String name;

        private EnumType(int ID, String name) {
            this.ID = ID;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getID() {
            return this.ID;
        }

        public static EnumType getConstant(int meta) {
            if (0 > meta || meta > 11) {
                meta = 0;
            }
            return EnumType.values()[meta];
        }
    }
}

