/*
 * Decompiled with CFR 0.152.
 */
package gaia;

import gaia.GaiaConfig;
import gaia.init.Aspects_Entity;
import gaia.init.Aspects_Items;
import gaia.init.GaiaBlocks;
import gaia.init.GaiaConfigGeneration;
import gaia.init.GaiaEntity;
import gaia.init.GaiaItems;
import gaia.init.GaiaSpawning;
import gaia.init.Sounds;
import gaia.items.GaiaIFuelHandler;
import gaia.proxy.CommonProxy;
import gaia.util.GaiaICommand;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="grimoireofgaia", name="Grimoire of Gaia 3", version="1.5.6", guiFactory="gaia.init.Config_GuiFactory", dependencies="after:Baubles; after:Thaumcraft", acceptedMinecraftVersions="[1.10.2]")
public class Gaia {
    @Mod.Instance(value="grimoireofgaia")
    public static Gaia instance = new Gaia();
    @SidedProxy(clientSide="gaia.proxy.ClientProxy", serverSide="gaia.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final Logger logger;
    public static boolean isBaublesEnabled;
    public static boolean isThaumcraftEnabled;
    public static CreativeTabs tabGaia;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        isBaublesEnabled = Loader.isModLoaded((String)"Baubles");
        if (isBaublesEnabled) {
            logger.info("Loading With Baubles");
        } else {
            logger.info("Loading Without Baubles");
        }
        isThaumcraftEnabled = Loader.isModLoaded((String)"Thaumcraft");
        if (isThaumcraftEnabled) {
            logger.info("Loading With Thaumcraft");
        } else {
            logger.info("Loading Without Thaumcraft");
        }
        GaiaConfigGeneration.configOptions(event);
        logger.info("Registering Items");
        GaiaBlocks.init();
        GaiaBlocks.register();
        GaiaItems.init();
        GaiaItems.register();
        logger.info("Items Registered");
        GaiaItems.oreRegistration();
        Sounds.Sounds_Init();
        proxy.registerItemsRender();
        proxy.registerBlocksRender();
        proxy.registerHandlers();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        GameRegistry.registerFuelHandler((IFuelHandler)new GaiaIFuelHandler());
        GaiaBlocks.addRecipes();
        GaiaItems.addRecipes();
        GaiaItems.addFurnaceRecipes();
        GaiaItems.addBrews();
        logger.info("Registering Entities");
        GaiaEntity.register();
        logger.info("Entities Registered");
        if (isThaumcraftEnabled) {
            logger.info("Registering Aspects");
            Aspects_Entity.Entity_Aspects();
            Aspects_Items.Item_Aspects();
            logger.info("Aspects Successfully Loaded");
        }
        proxy.registerRenders();
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (GaiaConfig.Biome_Tweaks) {
            GaiaSpawning.Biome_Tweaks();
        }
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new GaiaICommand());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (GaiaConfig.Enable_Spawn) {
            GaiaSpawning.register();
        }
    }

    static {
        logger = LogManager.getLogger((String)"grimoireofgaia");
        isBaublesEnabled = false;
        isThaumcraftEnabled = false;
        tabGaia = new CreativeTabs("tabGaia"){

            public Item func_78016_d() {
                return GaiaItems.MiscBook;
            }
        };
    }
}

