/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.integration;

import com.feed_the_beast.ftbl.api.info.IPageIconRenderer;
import com.feed_the_beast.ftbl.lib.info.InfoExtendedTextLine;
import com.feed_the_beast.ftbl.lib.info.InfoPage;
import com.feed_the_beast.ftbl.lib.info.ItemListLine;
import com.feed_the_beast.ftbl.lib.info.ItemPageIconRenderer;
import com.feed_the_beast.ftbl.lib.util.LMJsonUtils;
import com.feed_the_beast.ftbl.lib.util.LMStringUtils;
import com.feed_the_beast.ftbu.api.guide.ClientGuideEvent;
import com.feed_the_beast.ftbu.api.guide.IGuide;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.IResource;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.tools.TinkerMaterials;

public class TiCIntegration {
    public static void init() {
        MinecraftForge.EVENT_BUS.register(TiCIntegration.class);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onGuideEvent(ClientGuideEvent event) {
        IGuide guide = event.getModGuide("tconstruct");
        InfoPage pageGuide = guide.getPage();
        pageGuide.setIcon((IPageIconRenderer)new ItemPageIconRenderer(Item.func_111206_d((String)"tconstruct:toolforge")));
        InfoPage pageIntro = TiCIntegration.loadPage(event, "intro");
        if (pageIntro != null) {
            pageIntro.setTitle((ITextComponent)new TextComponentString("Introduction"));
            pageIntro.setIcon((IPageIconRenderer)new ItemPageIconRenderer(new ItemStack(Item.func_111206_d((String)"tconstruct:tooltables"), 1, 0)));
            pageGuide.addSub(pageIntro);
        }
        InfoPage toolMaterials = pageGuide.getSub("materials");
        toolMaterials.setTitle((ITextComponent)new TextComponentString("Materials"));
        toolMaterials.setIcon((IPageIconRenderer)new ItemPageIconRenderer(new ItemStack(Items.field_151035_b)));
        ImmutableList mats = ImmutableList.of((Object)TinkerMaterials.wood, (Object)TinkerMaterials.cobalt, (Object)TinkerMaterials.ardite, (Object)TinkerMaterials.manyullyn);
        for (Object material : TinkerRegistry.getAllMaterials()) {
            if (material.isHidden() || !material.hasItems()) continue;
            InfoPage page = toolMaterials.getSub(material.getIdentifier());
            page.setIcon((IPageIconRenderer)new ItemPageIconRenderer(material.getRepresentativeItem()));
            page.setTitle((ITextComponent)new TextComponentString(material.getLocalizedName()));
            for (IMaterialStats stats : material.getAllStats()) {
                TextComponentString component = new TextComponentString(stats.getLocalizedName());
                component.func_150256_b().func_150228_d(Boolean.valueOf(true));
                page.println((Object)component);
                ArrayList<ItemStack> parts = new ArrayList<ItemStack>();
                for (IToolPart part : TinkerRegistry.getToolParts()) {
                    if (!part.hasUseForStat(stats.getIdentifier())) continue;
                    parts.add(part.getItemstackWithMaterial((Material)material));
                }
                if (parts.size() > 0) {
                    page.println((Object)new ItemListLine(parts, 8));
                }
                for (int i = 0; i < stats.getLocalizedInfo().size(); ++i) {
                    TextComponentString component1 = new TextComponentString(TiCIntegration.transformString((String)stats.getLocalizedInfo().get(i)));
                    component1.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(TiCIntegration.transformString((String)stats.getLocalizedDesc().get(i)))));
                    page.println((Object)new InfoExtendedTextLine((ITextComponent)component1));
                }
                page.println(null);
            }
        }
        InfoPage modifiers = pageGuide.getSub("modifiers");
        modifiers.setTitle((ITextComponent)new TextComponentString("Modifiers"));
        modifiers.setIcon((IPageIconRenderer)new ItemPageIconRenderer(new ItemStack(Items.field_151137_ax)));
        for (IModifier modifier : TinkerRegistry.getAllModifiers()) {
            if (modifier.isHidden() || !modifier.hasItemsToApplyWith()) continue;
            try {
                IResource resource = event.getResourceManager().func_110536_a(new ResourceLocation("tconstruct", "book/en_US/modifiers/" + modifier.getIdentifier() + ".json"));
                JsonElement json = LMJsonUtils.fromJson((Reader)new InputStreamReader(resource.func_110527_b()));
                if (!json.isJsonObject()) continue;
                JsonObject o = json.getAsJsonObject();
                InfoPage page = modifiers.getSub(modifier.getIdentifier());
                page.setTitle((ITextComponent)new TextComponentString(modifier.getLocalizedName()));
                page.println((Object)TiCIntegration.transformString(modifier.getLocalizedDesc()));
                ArrayList<ItemStack> displayItems = new ArrayList<ItemStack>();
                if (o.has("text")) {
                    page.println(null);
                    for (JsonElement e : o.get("text").getAsJsonArray()) {
                        page.println((Object)LMJsonUtils.deserializeTextComponent((JsonElement)e));
                    }
                }
                if (o.has("effects")) {
                    page.println(null);
                    page.println((Object)"Effects:");
                    for (JsonElement e : o.get("effects").getAsJsonArray()) {
                        page.println((Object)LMJsonUtils.deserializeTextComponent((JsonElement)e));
                    }
                }
                if (!o.has("demoTool")) continue;
                for (JsonElement e : o.get("demoTool").getAsJsonArray()) {
                    Item item = Item.func_111206_d((String)e.getAsString());
                    if (!(item instanceof ToolCore)) continue;
                    displayItems.add(((ToolCore)item).buildItemForRendering((List)mats.subList(0, ((ToolCore)item).getRequiredComponents().size())));
                }
                if (displayItems.isEmpty()) continue;
                page.println(null);
                page.println((Object)new ItemListLine(displayItems, 8));
            }
            catch (Exception exception) {}
        }
        modifiers.sort(false);
        InfoPage pageSmeltry = TiCIntegration.loadPage(event, "smeltery");
        if (pageSmeltry != null) {
            pageSmeltry.setTitle((ITextComponent)new TextComponentString("Smeltry"));
            pageSmeltry.setIcon((IPageIconRenderer)new ItemPageIconRenderer(new ItemStack(Item.func_111206_d((String)"tconstruct:toolstation"), 1, 0)));
            pageGuide.addSub(pageSmeltry);
        }
        event.add(guide);
    }

    private static String transformString(String s) {
        return LMStringUtils.trimAllWhitespace((String)s.replace("\\n", "\n"));
    }

    @Nullable
    private static InfoPage loadPage(ClientGuideEvent event, String id) {
        try {
            IResource resource = event.getResourceManager().func_110536_a(new ResourceLocation("tconstruct", "book/en_US/sections/" + id + ".json"));
            JsonElement json = LMJsonUtils.fromJson((Reader)new InputStreamReader(resource.func_110527_b()));
            if (json.isJsonArray()) {
                for (JsonElement jsonElement : json.getAsJsonArray()) {
                }
                InfoPage page = new InfoPage(id);
                return page;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

