/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.handlers;

import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.api.events.player.ForgePlayerDeathEvent;
import com.feed_the_beast.ftbl.api.events.player.ForgePlayerLoggedInEvent;
import com.feed_the_beast.ftbl.api.events.player.ForgePlayerLoggedOutEvent;
import com.feed_the_beast.ftbl.api.events.player.ForgePlayerSettingsEvent;
import com.feed_the_beast.ftbl.lib.config.PropertyItemStack;
import com.feed_the_beast.ftbl.lib.config.PropertyTextComponent;
import com.feed_the_beast.ftbl.lib.math.BlockPosContainer;
import com.feed_the_beast.ftbl.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbl.lib.math.EntityDimPos;
import com.feed_the_beast.ftbl.lib.util.LMInvUtils;
import com.feed_the_beast.ftbu.FTBLibIntegration;
import com.feed_the_beast.ftbu.FTBUNotifications;
import com.feed_the_beast.ftbu.api.chunks.BlockInteractionType;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunkStorage;
import com.feed_the_beast.ftbu.api_impl.LoadedChunkStorage;
import com.feed_the_beast.ftbu.config.FTBUConfigLogin;
import com.feed_the_beast.ftbu.config.FTBUConfigWorld;
import com.feed_the_beast.ftbu.net.MessageSendFTBUClientFlags;
import com.feed_the_beast.ftbu.world.FTBUPlayerData;
import com.feed_the_beast.ftbu.world.FTBUUniverseData;
import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.UUID;
import mod.chiselsandbits.api.EventBlockBitModification;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FTBUPlayerEventHandler {
    @SubscribeEvent
    public static void onLoggedIn(ForgePlayerLoggedInEvent event) {
        if (event.getPlayer().isFake()) {
            return;
        }
        EntityPlayerMP ep = event.getPlayer().getPlayer();
        if (event.isFirstLogin() && FTBUConfigLogin.ENABLE_STARTING_ITEMS.getBoolean()) {
            for (IConfigValue value : FTBUConfigLogin.STARTING_ITEMS) {
                LMInvUtils.giveItem((EntityPlayer)ep, (ItemStack)((PropertyItemStack)value).getItem());
            }
        }
        if (FTBUConfigLogin.ENABLE_MOTD.getBoolean()) {
            for (IConfigValue value : FTBUConfigLogin.MOTD) {
                ITextComponent t = ((PropertyTextComponent)value).getText();
                if (t == null) continue;
                ep.func_145747_a(t);
            }
        }
        LoadedChunkStorage.INSTANCE.checkAll();
        HashMap<UUID, Integer> map = new HashMap<UUID, Integer>(1);
        int flags = FTBUPlayerData.get(event.getPlayer()).getClientFlags();
        map.put(ep.func_146103_bH().getId(), flags);
        new MessageSendFTBUClientFlags(map).sendTo(null);
        map.clear();
        for (IForgePlayer player : FTBLibIntegration.API.getUniverse().getOnlinePlayers()) {
            FTBUPlayerData data = FTBUPlayerData.get(player);
            if (data == null) continue;
            map.put(player.getId(), data.getClientFlags());
        }
        new MessageSendFTBUClientFlags(map).sendTo((EntityPlayer)ep);
    }

    @SubscribeEvent
    public static void onLoggedOut(ForgePlayerLoggedOutEvent event) {
        LoadedChunkStorage.INSTANCE.checkAll();
    }

    @SubscribeEvent
    public static void onDeath(ForgePlayerDeathEvent event) {
        FTBUPlayerData data = FTBUPlayerData.get(event.getPlayer());
        if (data != null) {
            data.lastDeath = new EntityDimPos((Entity)event.getPlayer().getPlayer()).toBlockDimPos();
        }
    }

    @SubscribeEvent
    public static void getSettings(ForgePlayerSettingsEvent event) {
        FTBUPlayerData data = FTBUPlayerData.get(event.getPlayer());
        if (data != null) {
            data.addConfig(event.getSettings());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onChunkChanged(EntityEvent.EnteringChunk e) {
        if (e.getEntity().field_70170_p.field_72995_K || !(e.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP ep = (EntityPlayerMP)e.getEntity();
        IForgePlayer player = FTBLibIntegration.API.getUniverse().getPlayer((Object)ep);
        if (player == null || !player.isOnline()) {
            return;
        }
        FTBUPlayerData data = FTBUPlayerData.get(player);
        if (data != null) {
            data.lastSafePos = new EntityDimPos((Entity)ep).toBlockDimPos();
        }
        FTBUPlayerEventHandler.updateChunkMessage(ep, new ChunkDimPos(e.getNewChunkX(), e.getNewChunkZ(), ep.field_71093_bK));
    }

    public static void updateChunkMessage(EntityPlayerMP player, ChunkDimPos pos) {
        IForgePlayer newTeamOwner = ClaimedChunkStorage.INSTANCE.getChunkOwner(pos);
        FTBUPlayerData data = FTBUPlayerData.get(FTBLibIntegration.API.getUniverse().getPlayer((Object)player));
        if (data == null) {
            return;
        }
        if (!Objects.equal((Object)data.lastChunkOwner, (Object)newTeamOwner)) {
            data.lastChunkOwner = newTeamOwner;
            if (newTeamOwner != null) {
                IForgeTeam team = newTeamOwner.getTeam();
                if (team != null) {
                    FTBLibIntegration.API.sendNotification((EntityPlayer)player, FTBUNotifications.chunkChanged(team));
                }
            } else {
                FTBLibIntegration.API.sendNotification((EntityPlayer)player, FTBUNotifications.chunkChanged(null));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerAttacked(LivingAttackEvent e) {
        if (e.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (e.getEntity().field_71093_bK != 0 || !(e.getEntity() instanceof EntityPlayerMP) || e.getEntity() instanceof FakePlayer) {
            return;
        }
        Entity entity = e.getSource().func_76364_f();
        if (entity != null && (entity instanceof EntityPlayerMP || entity instanceof IMob)) {
            if (entity instanceof FakePlayer) {
                return;
            }
            if (FTBUConfigWorld.SAFE_SPAWN.getBoolean() && FTBUUniverseData.isInSpawnD(e.getEntity().field_71093_bK, e.getEntity().field_70165_t, e.getEntity().field_70161_v)) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP && !ClaimedChunkStorage.INSTANCE.canPlayerInteract((EntityPlayerMP)event.getEntityPlayer(), event.getHand(), new BlockPosContainer((PlayerInteractEvent)event), BlockInteractionType.INTERACT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP && !ClaimedChunkStorage.INSTANCE.canPlayerInteract((EntityPlayerMP)event.getEntityPlayer(), event.getHand(), new BlockPosContainer((PlayerInteractEvent)event), BlockInteractionType.ITEM)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() instanceof EntityPlayerMP && !ClaimedChunkStorage.INSTANCE.canPlayerInteract((EntityPlayerMP)event.getPlayer(), EnumHand.MAIN_HAND, new BlockPosContainer(event.getWorld(), event.getPos(), event.getState()), BlockInteractionType.EDIT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (event.getPlayer() instanceof EntityPlayerMP && !ClaimedChunkStorage.INSTANCE.canPlayerInteract((EntityPlayerMP)event.getPlayer(), EnumHand.MAIN_HAND, new BlockPosContainer(event.getWorld(), event.getPos(), event.getPlacedBlock()), BlockInteractionType.EDIT)) {
            event.setCanceled(true);
        }
    }

    @Optional.Method(modid="chiselsandbits")
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onChiselEvent(EventBlockBitModification event) {
        if (event.getPlayer() instanceof EntityPlayerMP && !ClaimedChunkStorage.INSTANCE.canPlayerInteract((EntityPlayerMP)event.getPlayer(), event.getHand(), new BlockPosContainer(event.getWorld(), event.getPos(), event.getWorld().func_180495_p(event.getPos())), event.isPlacing() ? BlockInteractionType.CNB_PLACE : BlockInteractionType.CNB_BREAK)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP && !ClaimedChunkStorage.INSTANCE.canPlayerInteract((EntityPlayerMP)event.getEntityPlayer(), event.getHand(), new BlockPosContainer((PlayerInteractEvent)event), BlockInteractionType.EDIT)) {
            event.setCanceled(true);
        }
    }
}

