/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu;

import com.feed_the_beast.ftbl.api.IFTBLibRegistry;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.config.PropertyList;
import com.feed_the_beast.ftbl.lib.config.PropertyShort;
import com.feed_the_beast.ftbl.lib.config.PropertyString;
import com.feed_the_beast.ftbl.lib.math.BlockPosContainer;
import com.feed_the_beast.ftbu.FTBUCommon;
import com.feed_the_beast.ftbu.api.IFTBUtilitiesRegistry;
import com.feed_the_beast.ftbu.api.NodeEntry;
import com.feed_the_beast.ftbu.api.chunks.BlockInteractionType;
import com.feed_the_beast.ftbu.api.chunks.IChunkUpgrade;
import com.feed_the_beast.ftbu.api_impl.FTBUtilitiesAPI_Impl;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public class FTBUPermissions {
    public static final String DISPLAY_ADMIN_INFO = "ftbu.display.admin_info";
    public static final String DISPLAY_PERMISSIONS = "ftbu.display.permissions";
    public static final String BADGE = "ftbu.badge";
    public static final String HOMES_CROSS_DIM = "ftbu.homes.cross_dim";
    public static final String HOMES_MAX = "ftbu.homes.max";
    public static final String CLAIMS_CHUNKS_MODIFY_SELF = "ftbu.claims.modify.self";
    public static final String CLAIMS_CHUNKS_MODIFY_OTHERS = "ftbu.claims.modify.others";
    public static final String CLAIMS_MAX_CHUNKS = "ftbu.claims.max_chunks";
    public static final String CLAIMS_BLOCK_CNB = "ftbu.claims.block.cnb";
    private static final String CLAIMS_BLOCK_EDIT_PREFIX = "ftbu.claims.block.edit.";
    private static final String CLAIMS_BLOCK_INTERACT_PREFIX = "ftbu.claims.block.interact.";
    private static final String CLAIMS_ITEM_PREFIX = "ftbu.claims.item.";
    private static final String CLAIMS_BLOCKED_DIMENSIONS = "ftbu.claims.blocked_dimensions";
    private static final String CLAIMS_UPGRADE_PREFIX = "ftbu.claims.upgrade.";
    public static final String INFINITE_BACK_USAGE = "ftbu.back.infinite";
    public static final String CHUNKLOADER_MAX_CHUNKS = "ftbu.chunkloader.max_chunks";
    public static final String CHUNKLOADER_LOAD_OFFLINE = "ftbu.chunkloader.load_offline";

    public static void init() {
        String name;
        PermissionAPI.registerNode((String)DISPLAY_ADMIN_INFO, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Display 'Admin' in Server Info");
        PermissionAPI.registerNode((String)DISPLAY_PERMISSIONS, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Display 'My Permissions' in Server Info");
        PermissionAPI.registerNode((String)HOMES_CROSS_DIM, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can use /home to teleport to/from another dimension");
        PermissionAPI.registerNode((String)CLAIMS_CHUNKS_MODIFY_SELF, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Allow player to claim/unclaim his chunks");
        PermissionAPI.registerNode((String)CLAIMS_CHUNKS_MODIFY_OTHERS, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow player to modify other player's chunks");
        PermissionAPI.registerNode((String)CLAIMS_BLOCK_CNB, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allow to edit C&B bits in claimed chunks");
        PermissionAPI.registerNode((String)INFINITE_BACK_USAGE, (DefaultPermissionLevel)DefaultPermissionLevel.NONE, (String)"Allow to use 'back' command infinite times");
        PermissionAPI.registerNode((String)CHUNKLOADER_LOAD_OFFLINE, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Keep loaded chunks working when player goes offline");
        HashMap<String, DefaultPermissionLevel> levels = new HashMap<String, DefaultPermissionLevel>();
        for (Block block : Block.field_149771_c) {
            name = FTBUPermissions.formatId(block);
            levels.put(CLAIMS_BLOCK_EDIT_PREFIX + name, name.startsWith("graves.") || name.startsWith("gravestone.") ? DefaultPermissionLevel.ALL : DefaultPermissionLevel.OP);
            levels.put(CLAIMS_BLOCK_INTERACT_PREFIX + name, block instanceof BlockDoor || block instanceof BlockWorkbench || block instanceof BlockAnvil ? DefaultPermissionLevel.ALL : DefaultPermissionLevel.OP);
        }
        for (Item item : Item.field_150901_e) {
            name = FTBUPermissions.formatId(item);
            levels.put(CLAIMS_ITEM_PREFIX + name, item instanceof ItemBucket ? DefaultPermissionLevel.OP : DefaultPermissionLevel.ALL);
        }
        levels.put("ftbu.claims.block.edit.gravestone.gravestone", DefaultPermissionLevel.ALL);
        levels.put(CLAIMS_ITEM_PREFIX + FTBUPermissions.formatId(Items.field_185158_cP), DefaultPermissionLevel.OP);
        levels.put("ftbu.claims.item.forge.bucketfilled", DefaultPermissionLevel.OP);
        for (IChunkUpgrade upgrade : FTBUCommon.CHUNK_UPGRADES) {
            if (upgrade == null) continue;
            levels.put(CLAIMS_UPGRADE_PREFIX + upgrade.func_176610_l(), DefaultPermissionLevel.ALL);
        }
        levels.forEach(FTBUPermissions::registerNoDescNode);
    }

    private static void registerNoDescNode(String key, DefaultPermissionLevel level) {
        PermissionAPI.registerNode((String)key, (DefaultPermissionLevel)level, (String)"");
    }

    public static void addConfigs(IFTBLibRegistry reg) {
        reg.addRankConfig(BADGE, (IConfigValue)new PropertyString(""), (IConfigValue)new PropertyString(""), new String[]{"Badge (icon on chest). Must be an URL"});
        reg.addRankConfig(HOMES_MAX, (IConfigValue)new PropertyShort(1, 0, 30000), (IConfigValue)new PropertyShort(100), new String[]{"Max home count"});
        reg.addRankConfig(CLAIMS_MAX_CHUNKS, (IConfigValue)new PropertyShort(100, 0, 30000), (IConfigValue)new PropertyShort(1000), new String[]{"Max amount of chunks that player can claim", "0 - Disabled"});
        reg.addRankConfig(CLAIMS_BLOCKED_DIMENSIONS, (IConfigValue)new PropertyList("int"), (IConfigValue)new PropertyList("int"), new String[]{"Dimensions where chunk claiming is not allowed"});
        reg.addRankConfig(CHUNKLOADER_MAX_CHUNKS, (IConfigValue)new PropertyShort(50, 0, 30000), (IConfigValue)new PropertyShort(64), new String[]{"Max amount of chunks that player can load", "0 - Disabled"});
    }

    public static void addCustomPerms(IFTBUtilitiesRegistry reg) {
        reg.addCustomPermPrefix(new NodeEntry("command.", DefaultPermissionLevel.OP, "Permission for commands, if FTBU command overriding is enabled. If not, this node will be inactive"));
        reg.addCustomPermPrefix(new NodeEntry(CLAIMS_BLOCK_EDIT_PREFIX, DefaultPermissionLevel.OP, "Permission for blocks that players can break and place within claimed chunks"));
        reg.addCustomPermPrefix(new NodeEntry(CLAIMS_BLOCK_INTERACT_PREFIX, DefaultPermissionLevel.OP, "Permission for blocks that players can right-click within claimed chunks"));
        reg.addCustomPermPrefix(new NodeEntry(CLAIMS_ITEM_PREFIX, DefaultPermissionLevel.ALL, "Permission for items that players can right-click in air within claimed chunks"));
        reg.addCustomPermPrefix(new NodeEntry(CLAIMS_UPGRADE_PREFIX, DefaultPermissionLevel.ALL, "Permission for claimed chunk upgrades"));
    }

    private static String formatId(@Nullable IForgeRegistryEntry<?> item) {
        return item == null ? "minecraft.air" : item.getRegistryName().toString().toLowerCase().replace(':', '.');
    }

    public static boolean canModifyBlock(EntityPlayerMP player, EnumHand hand, BlockPosContainer block, BlockInteractionType type) {
        switch (type) {
            case EDIT: {
                return PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)(CLAIMS_BLOCK_EDIT_PREFIX + FTBUPermissions.formatId(block.getState().func_177230_c())), null);
            }
            case INTERACT: {
                return PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)(CLAIMS_BLOCK_INTERACT_PREFIX + FTBUPermissions.formatId(block.getState().func_177230_c())), null);
            }
            case CNB_BREAK: 
            case CNB_PLACE: {
                return PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)CLAIMS_BLOCK_CNB, null);
            }
            case ITEM: {
                return player.func_184586_b(hand) == null || PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)(CLAIMS_ITEM_PREFIX + FTBUPermissions.formatId(player.func_184586_b(hand).func_77973_b())), null);
            }
        }
        return false;
    }

    public static boolean allowDimension(GameProfile profile, int dimension) {
        IConfigValue value = FTBUtilitiesAPI_Impl.INSTANCE.getRankConfig(profile, CLAIMS_BLOCKED_DIMENSIONS);
        return !(value instanceof PropertyList) || !((PropertyList)value).containsValue((Object)dimension);
    }

    public static boolean canUpgradeChunk(GameProfile profile, IChunkUpgrade upgrade) {
        return PermissionAPI.hasPermission((GameProfile)profile, (String)(CLAIMS_UPGRADE_PREFIX + upgrade.func_176610_l()), null);
    }
}

