/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu;

import com.feed_the_beast.ftbl.api.EnumReloadType;
import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.IFTBLibClientRegistry;
import com.feed_the_beast.ftbl.api.IFTBLibPlugin;
import com.feed_the_beast.ftbl.api.IFTBLibRegistry;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.feed_the_beast.ftbu.FTBU;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.FTBUNotifications;
import com.feed_the_beast.ftbu.FTBUPermissions;
import com.feed_the_beast.ftbu.ServerInfoPage;
import com.feed_the_beast.ftbu.api_impl.FTBUtilitiesAPI_Impl;
import com.feed_the_beast.ftbu.api_impl.LoadedChunkStorage;
import com.feed_the_beast.ftbu.client.FTBUActions;
import com.feed_the_beast.ftbu.client.FTBUClientConfig;
import com.feed_the_beast.ftbu.cmd.FTBUCommands;
import com.feed_the_beast.ftbu.config.FTBUConfigBackups;
import com.feed_the_beast.ftbu.config.FTBUConfigCommands;
import com.feed_the_beast.ftbu.config.FTBUConfigGeneral;
import com.feed_the_beast.ftbu.config.FTBUConfigLogin;
import com.feed_the_beast.ftbu.config.FTBUConfigRanks;
import com.feed_the_beast.ftbu.config.FTBUConfigWebAPI;
import com.feed_the_beast.ftbu.config.FTBUConfigWorld;
import com.feed_the_beast.ftbu.config.PropertyChatSubstitute;
import com.feed_the_beast.ftbu.ranks.Ranks;
import com.feed_the_beast.ftbu.world.FTBUPlayerData;
import com.feed_the_beast.ftbu.world.FTBUTeamData;
import com.feed_the_beast.ftbu.world.FTBUUniverseData;
import java.io.File;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.server.command.CommandTreeBase;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.PermissionAPI;

public enum FTBLibIntegration implements IFTBLibPlugin
{
    INSTANCE;

    public static FTBLibAPI API;
    public static final ResourceLocation FTBU_DATA;

    public void init(FTBLibAPI api) {
        API = api;
    }

    public void loadWorldData(MinecraftServer server) {
        Ranks.reload();
    }

    public void onReload(Side side, ICommandSender sender, EnumReloadType type) {
        if (side.isServer()) {
            if (type.command()) {
                Ranks.reload();
            }
            ServerInfoPage.reloadCachedInfo();
            FTBUUniverseData.reloadServerBadges();
            LoadedChunkStorage.INSTANCE.checkAll();
        } else {
            FTBU.PROXY.onReloadedClient();
        }
    }

    public void registerCommon(IFTBLibRegistry reg) {
        reg.addOptionalServerMod("ftbu");
        reg.addConfigFileProvider("ftbu", () -> new File(LMUtils.folderLocal, "ftbu/config.json"));
        reg.addConfigValueProvider("ftbu_chat_substitute", PropertyChatSubstitute::new);
        FTBUConfigBackups.init(reg);
        FTBUConfigCommands.init(reg);
        FTBUConfigGeneral.init(reg);
        FTBUConfigLogin.init(reg);
        FTBUConfigWebAPI.init(reg);
        FTBUConfigWorld.init(reg);
        FTBUConfigRanks.init(reg);
        FTBUNotifications.init(reg);
        reg.addUniverseDataProvider(FTBU_DATA, owner -> new FTBUUniverseData());
        reg.addPlayerDataProvider(FTBU_DATA, owner -> new FTBUPlayerData());
        reg.addTeamDataProvider(FTBU_DATA, owner -> new FTBUTeamData());
        FTBUPermissions.addConfigs(reg);
    }

    public void configLoaded(LoaderState.ModState state) {
        if (state == LoaderState.ModState.PREINITIALIZED && FTBUConfigRanks.ENABLED.getBoolean()) {
            PermissionAPI.setPermissionHandler((IPermissionHandler)FTBUtilitiesAPI_Impl.INSTANCE);
        }
    }

    public void registerClient(IFTBLibClientRegistry reg) {
        reg.addClientConfig("ftbu", "render_badges", (IConfigValue)FTBUClientConfig.RENDER_BADGES, new int[0]);
        reg.addClientConfig("ftbu", "journeymap_overlay", (IConfigValue)FTBUClientConfig.JOURNEYMAP_OVERLAY, new int[0]);
        reg.addSidebarButton(FTBUActions.GUIDE);
        reg.addSidebarButton(FTBUActions.SERVER_INFO);
        reg.addSidebarButton(FTBUActions.CLAIMED_CHUNKS);
        reg.addSidebarButton(FTBUActions.TRASH_CAN);
        reg.addSidebarButton(FTBUActions.SHOP);
        if (!LMUtils.isNEILoaded) {
            reg.addSidebarButton(FTBUActions.HEAL);
            reg.addSidebarButton(FTBUActions.TOGGLE_GAMEMODE);
            reg.addSidebarButton(FTBUActions.TOGGLE_RAIN);
            reg.addSidebarButton(FTBUActions.TOGGLE_DAY);
            reg.addSidebarButton(FTBUActions.TOGGLE_NIGHT);
        }
    }

    public void registerFTBCommands(CommandTreeBase command, boolean dedi) {
        FTBUCommands.register(command, dedi);
    }

    static {
        FTBU_DATA = FTBUFinals.get("data");
    }
}

