/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.util;

import com.feed_the_beast.ftbl.lib.item.ToolLevel;
import com.feed_the_beast.ftbl.lib.item.ToolType;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class LMInvUtils {
    public static final IInventory EMPTY_INVENTORY = new InventoryBasic("[Null]", true, 0);
    private static Method baublesMethod = null;
    public static final ItemStack ERROR_ITEM = new ItemStack(Blocks.field_180401_cv);

    public static void addPlayerSlots(Container container, EntityPlayer player, int posX, int posY, boolean ignoreCurrent) {
        int x;
        if (player.field_71071_by == null) {
            return;
        }
        for (int y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                container.func_75146_a(new Slot((IInventory)player.field_71071_by, x + y * 9 + 9, posX + x * 18, posY + y * 18));
            }
        }
        int i = ignoreCurrent ? player.field_71071_by.field_70461_c : -1;
        for (x = 0; x < 9; ++x) {
            if (x != i) {
                container.func_75146_a(new Slot((IInventory)player.field_71071_by, x, posX + x * 18, posY + 58));
                continue;
            }
            container.func_75146_a(new Slot((IInventory)player.field_71071_by, x, posX + x * 18, posY + 58){

                public boolean func_82869_a(EntityPlayer ep) {
                    return false;
                }
            });
        }
    }

    @Nullable
    public static ItemStack transferStackInSlot(Container container, int index, int nonPlayerSlots) {
        if (nonPlayerSlots <= 0) {
            return null;
        }
        ItemStack is = null;
        Slot slot = (Slot)container.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack is1 = slot.func_75211_c();
            is = is1.func_77946_l();
            if (index < nonPlayerSlots ? !container.func_75135_a(is1, nonPlayerSlots, container.field_75151_b.size(), true) : !container.func_75135_a(is1, 0, nonPlayerSlots, false)) {
                return null;
            }
            if (is1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
        }
        return is;
    }

    public static ItemStack singleCopy(@Nullable ItemStack is) {
        if (is != null && is.field_77994_a > 0) {
            ItemStack is1 = is.func_77946_l();
            is1.field_77994_a = 1;
            return is1;
        }
        return null;
    }

    public static boolean itemsEquals(@Nullable ItemStack is1, @Nullable ItemStack is2, boolean size, boolean nbt) {
        return is1 == null && is2 == null || is1 != null && is2 != null && is1.func_77973_b() == is2.func_77973_b() && is1.func_77952_i() == is2.func_77952_i() && (!nbt || ItemStack.func_77970_a((ItemStack)is1, (ItemStack)is2)) && (!size || is1.field_77994_a == is2.field_77994_a);
    }

    @Nullable
    public static ItemStack getAndSplit(IItemHandlerModifiable itemHandler, int index, int amount) {
        if (index >= 0 && index < itemHandler.getSlots() && itemHandler.getStackInSlot(index) != null && amount > 0) {
            ItemStack itemstack = itemHandler.getStackInSlot(index).func_77979_a(amount);
            if (itemHandler.getStackInSlot((int)index).field_77994_a == 0) {
                itemHandler.setStackInSlot(index, null);
            }
            return itemstack;
        }
        return null;
    }

    @Nullable
    public static ItemStack getAndRemove(IItemHandlerModifiable itemHandler, int index) {
        ItemStack itemStack = itemHandler.getStackInSlot(index);
        itemHandler.setStackInSlot(index, null);
        return itemStack;
    }

    public static void clear(IItemHandlerModifiable itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            itemHandler.setStackInSlot(i, null);
        }
    }

    public static void dropItem(World w, double x, double y, double z, double mx, double my, double mz, ItemStack item, int delay) {
        if (item.field_77994_a > 0) {
            EntityItem ei = new EntityItem(w, x, y, z, item.func_77946_l());
            ei.field_70159_w = mx;
            ei.field_70181_x = my;
            ei.field_70179_y = mz;
            ei.func_174867_a(delay);
            w.func_72838_d((Entity)ei);
        }
    }

    public static void dropItem(World w, double x, double y, double z, ItemStack item, int delay) {
        LMInvUtils.dropItem(w, x, y, z, w.field_73012_v.nextGaussian() * (double)0.07f, w.field_73012_v.nextFloat() * 0.05f, w.field_73012_v.nextGaussian() * (double)0.07f, item, delay);
    }

    public static void dropItem(World w, BlockPos pos, ItemStack item, int delay) {
        LMInvUtils.dropItem(w, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, item, delay);
    }

    public static void dropItem(Entity e, ItemStack item) {
        LMInvUtils.dropItem(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, item, 0);
    }

    public static void giveItem(EntityPlayer ep, @Nullable ItemStack item) {
        if (item != null && item.field_77994_a > 0) {
            if (ep.field_71071_by.func_70441_a(item)) {
                ep.field_71071_by.func_70296_d();
                if (ep.field_71070_bA != null) {
                    ep.field_71070_bA.func_75142_b();
                }
            } else {
                LMInvUtils.dropItem((Entity)ep, item);
            }
        }
    }

    public static void dropAllItems(World w, double x, double y, double z, Iterable<ItemStack> items) {
        if (!w.field_72995_K) {
            for (ItemStack item : items) {
                if (item == null || item.field_77994_a <= 0) continue;
                LMInvUtils.dropItem(w, x, y, z, item, 10);
            }
        }
    }

    public static boolean canStack(@Nullable ItemStack is1, @Nullable ItemStack is2) {
        return is1 != null && is2 != null && is1.field_77994_a + is2.field_77994_a <= is1.func_77976_d() && is1.field_77994_a + is2.field_77994_a <= is2.func_77976_d();
    }

    @Nullable
    public static ItemStack reduceItem(@Nullable ItemStack is) {
        if (is == null || is.field_77994_a <= 0) {
            return null;
        }
        if (is.field_77994_a == 1) {
            if (is.func_77973_b().hasContainerItem(is)) {
                return is.func_77973_b().getContainerItem(is);
            }
            return null;
        }
        is.func_77979_a(1);
        return is;
    }

    public static boolean isWrench(@Nullable ItemStack is) {
        return is != null && is.func_77973_b().getHarvestLevel(is, ToolType.WRENCH.func_176610_l(), null, null) >= ToolLevel.BASIC.ordinal();
    }

    public static void removeDisplayName(ItemStack is) {
        if (is.func_77942_o() && is.func_77978_p().func_74764_b("display")) {
            NBTTagCompound tag1 = is.func_77978_p().func_74775_l("display");
            if (tag1.func_74764_b("Name")) {
                tag1.func_82580_o("Name");
                if (tag1.func_82582_d()) {
                    is.func_77978_p().func_82580_o("display");
                }
            }
            if (is.func_77978_p().func_82582_d()) {
                is.func_77982_d(null);
            }
        }
    }

    public static void transferItems(IItemHandler from, IItemHandler to, int transfer) {
        if (transfer <= 0) {
            return;
        }
        for (int i = 0; i < from.getSlots(); ++i) {
            int s;
            ItemStack extracted = from.extractItem(i, transfer, true);
            if (extracted == null || extracted.field_77994_a <= 0) continue;
            ItemStack inserted = ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)extracted, (boolean)false);
            int n = s = inserted == null ? extracted.field_77994_a : extracted.field_77994_a - inserted.field_77994_a;
            if (s <= 0) continue;
            from.extractItem(i, s, false);
            if ((transfer -= s) > 0) continue;
            return;
        }
    }

    public static IInventory getBaubles(EntityPlayer player) {
        IInventory ot = null;
        try {
            if (baublesMethod == null) {
                Class<?> fake = Class.forName("baubles.common.lib.PlayerHandler");
                baublesMethod = fake.getMethod("getPlayerBaubles", EntityPlayer.class);
            }
            ot = (IInventory)baublesMethod.invoke(null, player);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Baubles API] Could not invoke baubles.common.lib.PlayerHandler method getPlayerBaubles", (Object[])new Object[0]);
        }
        return ot;
    }

    static {
        ERROR_ITEM.func_151001_c("Broken Item!");
    }
}

