/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.util;

import com.feed_the_beast.ftbl.lib.math.MathHelperLM;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.awt.Color;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.BufferUtils;

public class LMColorUtils {
    private static final int[] CHAT_FORMATTING_COLORS = new int[16];
    private static final int[] DYE_TEXT_FORMATTING_COLORS = new int[32];

    public static int getChatFormattingColor(int id) {
        return CHAT_FORMATTING_COLORS[id & 0xF];
    }

    public static JsonElement serialize(int col) {
        return new JsonPrimitive('#' + Integer.toHexString(col).toUpperCase());
    }

    public static int deserialize(@Nullable JsonElement e) {
        if (e == null || !e.isJsonPrimitive()) {
            return -16777216;
        }
        return (int)Long.parseLong(e.getAsString().substring(1), 16);
    }

    public static int getRGBA(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int getRGBAF(float r, float g, float b, float a) {
        return LMColorUtils.getRGBA((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public static int getRed(int c) {
        return c >> 16 & 0xFF;
    }

    public static int getGreen(int c) {
        return c >> 8 & 0xFF;
    }

    public static int getBlue(int c) {
        return c & 0xFF;
    }

    public static int getAlpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static float getRedF(int c) {
        return (float)LMColorUtils.getRed(c) / 255.0f;
    }

    public static float getGreenF(int c) {
        return (float)LMColorUtils.getGreen(c) / 255.0f;
    }

    public static float getBlueF(int c) {
        return (float)LMColorUtils.getBlue(c) / 255.0f;
    }

    public static float getAlphaF(int c) {
        return (float)LMColorUtils.getAlpha(c) / 255.0f;
    }

    public static String getHex(int c) {
        return '#' + Integer.toHexString(LMColorUtils.getRGBA(c, 255)).substring(2).toUpperCase();
    }

    public static int getRGBA(int c, int a) {
        return LMColorUtils.getRGBA(LMColorUtils.getRed(c), LMColorUtils.getGreen(c), LMColorUtils.getBlue(c), a);
    }

    public static ByteBuffer toByteBuffer(int[] pixels, boolean alpha) {
        ByteBuffer bb = BufferUtils.createByteBuffer((int)(pixels.length * 4));
        byte alpha255 = -1;
        for (int p : pixels) {
            bb.put((byte)LMColorUtils.getRed(p));
            bb.put((byte)LMColorUtils.getGreen(p));
            bb.put((byte)LMColorUtils.getBlue(p));
            bb.put(alpha ? (byte)LMColorUtils.getAlpha(p) : alpha255);
        }
        bb.flip();
        return bb;
    }

    public static int addBrightness(int c, int b) {
        int red = MathHelper.func_76125_a((int)(LMColorUtils.getRed(c) + b), (int)0, (int)255);
        int green = MathHelper.func_76125_a((int)(LMColorUtils.getGreen(c) + b), (int)0, (int)255);
        int blue = MathHelper.func_76125_a((int)(LMColorUtils.getBlue(c) + b), (int)0, (int)255);
        return LMColorUtils.getRGBA(red, green, blue, LMColorUtils.getAlpha(c));
    }

    public static void addHSB(int[] pixels, float h, float s, float b) {
        if (pixels.length > 0) {
            float[] hsb = new float[3];
            for (int i = 0; i < pixels.length; ++i) {
                Color.RGBtoHSB(LMColorUtils.getRed(pixels[i]), LMColorUtils.getGreen(pixels[i]), LMColorUtils.getBlue(pixels[i]), hsb);
                hsb[0] = hsb[0] + h;
                hsb[1] = MathHelper.func_76131_a((float)(hsb[1] + s), (float)0.0f, (float)1.0f);
                hsb[2] = MathHelper.func_76131_a((float)(hsb[2] + b), (float)0.0f, (float)1.0f);
                pixels[i] = LMColorUtils.getRGBA(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]), 255);
            }
        }
    }

    public static int lerp(int col1, int col2, double m, int alpha) {
        m = MathHelper.func_151237_a((double)m, (double)0.0, (double)1.0);
        int r = MathHelperLM.lerp_int(LMColorUtils.getRed(col1), LMColorUtils.getRed(col2), m);
        int g = MathHelperLM.lerp_int(LMColorUtils.getGreen(col1), LMColorUtils.getGreen(col2), m);
        int b = MathHelperLM.lerp_int(LMColorUtils.getBlue(col1), LMColorUtils.getBlue(col2), m);
        return LMColorUtils.getRGBA(r, g, b, alpha);
    }

    public static int lerp(int col1, int col2, double m) {
        return LMColorUtils.lerp(col1, col2, m, LMColorUtils.getAlpha(col1));
    }

    public static int multiply(int col1, int col2, int a) {
        float r = MathHelper.func_76131_a((float)(LMColorUtils.getRedF(col1) * LMColorUtils.getRedF(col2)), (float)0.0f, (float)1.0f);
        float g = MathHelper.func_76131_a((float)(LMColorUtils.getGreenF(col1) * LMColorUtils.getGreenF(col2)), (float)0.0f, (float)1.0f);
        float b = MathHelper.func_76131_a((float)(LMColorUtils.getBlueF(col1) * LMColorUtils.getBlueF(col2)), (float)0.0f, (float)1.0f);
        return LMColorUtils.getRGBA((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), a);
    }

    public static TextFormatting getFromDyeColor(EnumDyeColor color) {
        return color.field_176793_x;
    }

    public static char getTextFormattingChar(TextFormatting formatting) {
        return formatting.field_96329_z;
    }

    public static int getDyeColor(EnumDyeColor color, boolean isLighter) {
        return DYE_TEXT_FORMATTING_COLORS[color.func_176765_a() + (isLighter ? 0 : 16)];
    }

    static {
        for (int i = 0; i < 16; ++i) {
            int j = (i >> 3 & 1) * 85;
            int r = (i >> 2 & 1) * 170 + j;
            int g = (i >> 1 & 1) * 170 + j;
            int b = (i & 1) * 170 + j;
            LMColorUtils.CHAT_FORMATTING_COLORS[i] = LMColorUtils.getRGBA(i == 6 ? r + 85 : r, g, b, 255);
        }
        for (EnumDyeColor color : EnumDyeColor.values()) {
            char c = LMColorUtils.getTextFormattingChar(LMColorUtils.getFromDyeColor(color));
            LMColorUtils.DYE_TEXT_FORMATTING_COLORS[color.func_176765_a()] = GuiUtils.getColorCode((char)c, (boolean)true);
            LMColorUtils.DYE_TEXT_FORMATTING_COLORS[color.func_176765_a() + 16] = GuiUtils.getColorCode((char)c, (boolean)false);
        }
    }
}

