/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.info;

import com.feed_the_beast.ftbl.api.info.IInfoTextLine;
import com.feed_the_beast.ftbl.lib.client.DrawableItemList;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.ItemListButton;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.info.EmptyInfoPageLine;
import com.feed_the_beast.ftbl.lib.info.InfoPage;
import com.feed_the_beast.ftbl.lib.item.ItemStackSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class ItemListLine
extends EmptyInfoPageLine {
    private final List<ItemStack> list;
    private final int cols;

    public ItemListLine(Collection<ItemStack> l, int columns) {
        this.list = new ArrayList<ItemStack>(l);
        this.cols = MathHelper.func_76125_a((int)columns, (int)0, (int)16);
    }

    public ItemListLine(JsonElement json) {
        block3: {
            block2: {
                this.list = new ArrayList<ItemStack>();
                if (!json.isJsonObject()) break block2;
                JsonObject o = json.getAsJsonObject();
                this.cols = MathHelper.func_76125_a((int)(o.has("columns") ? o.get("columns").getAsInt() : 8), (int)0, (int)16);
                if (!o.has("items")) break block3;
                for (JsonElement e : o.get("items").getAsJsonArray()) {
                    this.list.add(ItemStackSerializer.deserialize(e));
                }
                break block3;
            }
            this.cols = 8;
            for (JsonElement e : json.getAsJsonArray()) {
                this.list.add(ItemStackSerializer.deserialize(e));
            }
        }
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.add("id", (JsonElement)new JsonPrimitive("item_list"));
        return o;
    }

    @Override
    public Widget createWidget(GuiBase gui, Panel parent) {
        return new ItemListButton(0, 0, new DrawableItemList(this.list), this.cols);
    }

    @Override
    public IInfoTextLine copy(InfoPage page) {
        return new ItemListLine(this.list, this.cols);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }
}

