/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.info;

import com.feed_the_beast.ftbl.api.gui.IImageProvider;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.api.info.IInfoTextLine;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.info.EmptyInfoPageLine;
import com.feed_the_beast.ftbl.lib.info.InfoPage;
import com.feed_the_beast.ftbl.lib.util.LMJsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.event.ClickEvent;
import org.lwjgl.opengl.GL11;

public class InfoImageLine
extends EmptyInfoPageLine {
    public IImageProvider imageProvider = ImageProvider.NULL;
    public int imageWidth;
    public int imageHeight;
    public double imageScale = 1.0;
    public ClickEvent clickEvent;
    public List<String> hover;

    public InfoImageLine() {
    }

    public InfoImageLine(JsonElement e) {
        JsonObject o1;
        this.imageProvider = ImageProvider.NULL;
        this.imageHeight = 0;
        this.imageWidth = 0;
        this.imageScale = 1.0;
        this.hover = null;
        JsonObject o = e.getAsJsonObject();
        if (!o.has("image")) {
            return;
        }
        this.imageProvider = new ImageProvider(new ResourceLocation(o.get("image").getAsString()));
        if (o.has("scale")) {
            this.imageScale = o.get("scale").getAsDouble();
        } else if (o.has("size")) {
            this.imageWidth = this.imageHeight = o.get("size").getAsInt();
        } else {
            if (o.has("width")) {
                this.imageWidth = o.get("width").getAsInt();
            }
            if (o.has("height")) {
                this.imageHeight = o.get("height").getAsInt();
            }
        }
        if (o.has("clickEvent") && (o1 = o.get("clickEvent").getAsJsonObject()) != null) {
            String s;
            JsonPrimitive a = o1.getAsJsonPrimitive("action");
            ClickEvent.Action action = a == null ? null : ClickEvent.Action.func_150672_a((String)a.getAsString());
            JsonPrimitive v = o1.getAsJsonPrimitive("value");
            String string = s = v == null ? null : v.getAsString();
            if (action != null && s != null && action.func_150674_a()) {
                this.clickEvent = new ClickEvent(action, s);
            }
        }
        if (o.has("hover")) {
            this.hover = new ArrayList<String>();
            for (JsonElement e1 : o.get("hover").getAsJsonArray()) {
                this.hover.add(LMJsonUtils.deserializeTextComponent(e1).func_150254_d());
            }
        }
    }

    @Override
    public Widget createWidget(GuiBase gui, Panel parent) {
        return new ButtonInfoImage(parent);
    }

    @Override
    public IInfoTextLine copy(InfoPage page) {
        InfoImageLine line = new InfoImageLine();
        line.imageProvider = this.imageProvider;
        line.imageWidth = this.imageWidth;
        line.imageHeight = this.imageHeight;
        line.imageScale = this.imageScale;
        line.clickEvent = this.clickEvent;
        line.hover = new ArrayList<String>(this.hover);
        return line;
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.add("id", (JsonElement)new JsonPrimitive("img"));
        o.add("image", (JsonElement)new JsonPrimitive(this.imageProvider.getImage().toString()));
        if (this.imageScale != 1.0) {
            o.add("scale", (JsonElement)new JsonPrimitive((Number)this.imageScale));
        } else if (this.imageWidth != 0 || this.imageHeight != 0) {
            o.add("width", (JsonElement)new JsonPrimitive((Number)this.imageWidth));
            o.add("height", (JsonElement)new JsonPrimitive((Number)this.imageHeight));
        }
        if (this.hover != null) {
            JsonArray a = new JsonArray();
            for (String s : this.hover) {
                a.add((JsonElement)new JsonPrimitive(s));
            }
            o.add("hover", (JsonElement)a);
        }
        return o;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    private class ButtonInfoImage
    extends Button {
        private final Panel parent;

        private ButtonInfoImage(Panel p) {
            super(0, 0, 0, 0);
            this.parent = p;
            this.checkSize();
        }

        private void checkSize() {
            InfoImageLine.this.imageProvider.bindTexture();
            if (this.width == 1 || this.height == 1) {
                this.width = Math.max(InfoImageLine.this.imageWidth == 0 ? GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096) : InfoImageLine.this.imageWidth, 2);
                this.height = Math.max(InfoImageLine.this.imageHeight == 0 ? GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097) : InfoImageLine.this.imageHeight, 2);
                double w = Math.min((double)this.parent.width, (double)this.width * InfoImageLine.this.imageScale);
                double h = (double)this.height * (w / ((double)this.width * InfoImageLine.this.imageScale));
                this.setWidth((int)w);
                this.setHeight((int)h);
                this.parent.updateWidgetPositions();
            }
        }

        @Override
        public void renderWidget(GuiBase gui) {
            this.checkSize();
            InfoImageLine.this.imageProvider.draw(this, Color4I.NONE);
        }

        @Override
        public void addMouseOverText(GuiBase gui, List<String> list) {
            if (InfoImageLine.this.hover != null) {
                list.addAll(InfoImageLine.this.hover);
            }
        }

        @Override
        public void onClicked(GuiBase gui, IMouseButton button) {
            if (InfoImageLine.this.clickEvent != null) {
                GuiHelper.playClickSound();
                GuiHelper.onClickEvent(InfoImageLine.this.clickEvent);
            }
        }
    }
}

