/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.info;

import com.feed_the_beast.ftbl.api.info.IInfoTextLine;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.info.EmptyInfoPageLine;
import com.feed_the_beast.ftbl.lib.info.InfoPage;
import com.feed_the_beast.ftbl.lib.util.LMColorUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class InfoHrLine
extends EmptyInfoPageLine {
    public final int height;
    public final Color4I color;

    public InfoHrLine(int h, Color4I c) {
        this.height = h;
        this.color = c;
    }

    public InfoHrLine(JsonElement e) {
        JsonObject o = e.getAsJsonObject();
        this.height = o.has("height") ? Math.max(1, o.get("height").getAsInt()) : 1;
        this.color = o.has("color") ? new Color4I(0xFF000000 | LMColorUtils.deserialize(o.get("color"))) : Color4I.NONE;
    }

    @Override
    public Widget createWidget(GuiBase gui, Panel parent) {
        return new WidgetInfoHr(parent);
    }

    @Override
    public IInfoTextLine copy(InfoPage page) {
        return new InfoHrLine(this.height, this.color);
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.add("id", (JsonElement)new JsonPrimitive("hr"));
        o.add("height", (JsonElement)new JsonPrimitive((Number)this.height));
        o.add("color", this.color.toJson());
        return o;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    private class WidgetInfoHr
    extends Widget {
        private WidgetInfoHr(Panel parent) {
            super(0, 1, parent.width, InfoHrLine.this.height + 2);
        }

        @Override
        public void renderWidget(GuiBase gui) {
            GuiHelper.drawBlankRect(this.getAX(), this.getAY() + 1, this.width, this.height, InfoHrLine.this.color.hasColor() ? InfoHrLine.this.color : gui.getContentColor());
        }
    }
}

