/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui.misc;

import com.feed_the_beast.ftbl.api.config.IConfigContainer;
import com.feed_the_beast.ftbl.api.config.IConfigKey;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.api.config.IGuiEditConfig;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.ImmutableColor4I;
import com.feed_the_beast.ftbl.lib.MouseButton;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.EnumDirection;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.PanelScrollBar;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;

public class GuiEditConfig
extends GuiBase
implements IGuiEditConfig {
    public static final Comparator<Map.Entry<IConfigKey, IConfigValue>> COMPARATOR = Comparator.comparing(o -> ((IConfigKey)o.getKey()).getDisplayName().func_150254_d());
    public static final Color4I COLOR_BACKGROUND = new ImmutableColor4I(-1724697805);
    private final IConfigContainer configContainer;
    private final NBTTagCompound extraNBT;
    private final JsonObject modifiedConfig;
    private final String title;
    private final List<ButtonConfigEntry> configEntryButtons;
    private final Panel configPanel;
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final PanelScrollBar scroll;
    private int shouldClose = 0;

    public GuiEditConfig(@Nullable NBTTagCompound nbt, IConfigContainer cc) {
        super(0, 0);
        this.configContainer = cc;
        ITextComponent title0 = this.configContainer.getTitle().func_150259_f();
        title0.func_150256_b().func_150227_a(Boolean.valueOf(true));
        this.title = title0.func_150254_d();
        this.extraNBT = nbt;
        this.modifiedConfig = new JsonObject();
        this.configEntryButtons = new ArrayList<ButtonConfigEntry>();
        ArrayList<Map.Entry<IConfigKey, IConfigValue>> list = new ArrayList<Map.Entry<IConfigKey, IConfigValue>>();
        list.addAll(this.configContainer.getConfigTree().getTree().entrySet());
        Collections.sort(list, COMPARATOR);
        for (Map.Entry entry : list) {
            if (((IConfigKey)entry.getKey()).getFlag(2)) continue;
            this.configEntryButtons.add(new ButtonConfigEntry((IConfigKey)entry.getKey(), ((IConfigValue)entry.getValue()).copy()));
        }
        this.configPanel = new Panel(0, 20, 0, 20){

            @Override
            public void addWidgets() {
                this.addAll(GuiEditConfig.this.configEntryButtons);
            }

            @Override
            public void updateWidgetPositions() {
                GuiEditConfig.this.scroll.setElementSize(this.alignWidgets(EnumDirection.VERTICAL));
            }
        };
        this.configPanel.addFlags(3);
        this.buttonAccept = new Button(0, 2, 16, 16, GuiLang.BUTTON_ACCEPT.translate(new Object[0])){

            @Override
            public void onClicked(GuiBase gui, IMouseButton button) {
                GuiHelper.playClickSound();
                GuiEditConfig.this.shouldClose = 1;
                gui.closeGui();
            }
        };
        this.buttonAccept.setIcon(GuiIcons.ACCEPT);
        this.buttonCancel = new Button(0, 2, 16, 16, GuiLang.BUTTON_CANCEL.translate(new Object[0])){

            @Override
            public void onClicked(GuiBase gui, IMouseButton button) {
                GuiHelper.playClickSound();
                GuiEditConfig.this.shouldClose = 2;
                gui.closeGui();
            }
        };
        this.buttonCancel.setIcon(GuiIcons.CANCEL);
        this.scroll = new PanelScrollBar(-16, 20, 16, 0, 10, this.configPanel);
    }

    @Override
    public boolean isFullscreen() {
        return true;
    }

    @Override
    public void updateWidgetPositions() {
        this.buttonAccept.posX = this.width - 18;
        this.buttonCancel.posX = this.width - 38;
        this.configPanel.setHeight(this.height - 20);
        this.configPanel.setWidth(this.width);
        this.scroll.posX = this.width - 16;
        this.scroll.setHeight(this.configPanel.height);
        for (ButtonConfigEntry b : this.configEntryButtons) {
            b.setWidth(this.scroll.posX);
        }
    }

    @Override
    public void addWidgets() {
        this.add(this.scroll);
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        this.add(this.configPanel);
    }

    @Override
    public void onClosed() {
        if (this.shouldClose == 1 && !this.modifiedConfig.entrySet().isEmpty()) {
            this.configContainer.saveConfig((ICommandSender)this.mc.field_71439_g, this.extraNBT, this.modifiedConfig);
        }
    }

    @Override
    public boolean onClosedByKey() {
        this.buttonCancel.onClicked(this, MouseButton.LEFT);
        return false;
    }

    @Override
    public void onChanged(IConfigKey key, JsonElement val) {
        this.modifiedConfig.add(key.func_176610_l(), val);
    }

    @Override
    public void drawBackground() {
        GuiHelper.drawBlankRect(0, 0, this.width, 20, COLOR_BACKGROUND);
        this.getFont().func_78276_b(this.getTitle(this), 6, 6, -1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public String getTitle(GuiBase gui) {
        return this.title;
    }

    @Override
    public void onClientDataChanged() {
        this.refreshWidgets();
    }

    public class ButtonConfigEntry
    extends Button {
        public final IConfigKey key;
        public final IConfigValue value;
        public String keyText;
        public List<String> info;

        public ButtonConfigEntry(IConfigKey id, IConfigValue e) {
            super(0, 0, 0, 16);
            this.key = id;
            this.value = e;
            this.keyText = id.getDisplayName().func_150260_c();
            if (this.keyText.startsWith("config.") && this.keyText.endsWith(".name")) {
                this.keyText = id.func_176610_l();
            }
            if (!id.getInfo().isEmpty()) {
                this.info = GuiEditConfig.this.getFont().func_78271_c(id.getInfo(), 230);
            }
            if (this.info == null || this.info.isEmpty()) {
                this.info = Collections.emptyList();
            }
        }

        @Override
        public void renderWidget(GuiBase gui) {
            boolean mouseOver = gui.getMouseY() >= 20 && gui.isMouseOver(this);
            int ax = this.getAX();
            int ay = this.getAY();
            if (mouseOver) {
                GuiHelper.drawBlankRect(ax, ay, this.width, this.height, Color4I.WHITE_A33);
            }
            gui.drawString(this.keyText, ax + 4, ay + 4, mouseOver ? Color4I.WHITE : Color4I.GRAY);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String s = this.value.getString();
            int slen = gui.getFont().func_78256_a(s);
            if (slen > 150) {
                s = gui.getFont().func_78269_a(s, 150) + "...";
                slen = 152;
            }
            Color4I textCol = this.value.getColor().copy(false, 255);
            if (mouseOver) {
                textCol.addBrightness(60);
            }
            if (mouseOver && gui.getMouseX() > ax + this.width - slen - 9) {
                GuiHelper.drawBlankRect(ax + this.width - slen - 8, ay, slen + 8, this.height, Color4I.WHITE_A33);
            }
            gui.drawString(s, gui.width - (slen + 20), ay + 4, textCol);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onClicked(GuiBase gui, IMouseButton button) {
            if (gui.getMouseY() >= 20 && !this.key.getFlag(4)) {
                GuiHelper.playClickSound();
                this.value.onClicked(GuiEditConfig.this, this.key, button);
            }
        }

        @Override
        public void addMouseOverText(GuiBase gui, List<String> list) {
            if (gui.getMouseY() > 18) {
                if (!this.info.isEmpty() && gui.getMouseX() < this.getAX() + gui.getFont().func_78256_a(this.keyText) + 10) {
                    list.addAll(this.info);
                }
                if (gui.getMouseX() > gui.width - (Math.min(150, gui.getFont().func_78256_a(this.value.getString())) + 25)) {
                    this.value.addInfo(this.key, list);
                }
            }
        }
    }
}

