/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui.misc;

import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.MouseButton;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.TextBox;
import com.feed_the_beast.ftbl.lib.gui.misc.IGuiFieldCallback;

public class GuiConfigValueField
extends GuiBase {
    private final IConfigValue defValue;
    private final IConfigValue value;
    private final IGuiFieldCallback callback;
    private final Button buttonCancel;
    private final Button buttonAccept;
    private final TextBox textBox;

    GuiConfigValueField(IConfigValue val, IGuiFieldCallback c) {
        super(200, 60);
        this.defValue = val.copy();
        this.value = val.copy();
        this.callback = c;
        int bsize = this.width / 2 - 3;
        this.buttonCancel = new Button(2, this.height - 28, bsize, 26, GuiLang.BUTTON_CANCEL.translate(new Object[0])){

            @Override
            public void onClicked(GuiBase gui, IMouseButton button) {
                GuiHelper.playClickSound();
                GuiConfigValueField.this.callback.onCallback(GuiConfigValueField.this.defValue, false);
            }

            @Override
            public Color4I renderTitleInCenter(GuiBase gui) {
                return gui.getContentColor();
            }
        };
        this.buttonCancel.setIcon(Button.DEFAULT_BACKGROUND);
        this.buttonAccept = new Button(this.width - bsize - 2, this.height - 28, bsize, 26, GuiLang.BUTTON_ACCEPT.translate(new Object[0])){

            @Override
            public void onClicked(GuiBase gui, IMouseButton button) {
                GuiHelper.playClickSound();
                if (GuiConfigValueField.this.value.setValueFromString(GuiConfigValueField.this.textBox.getText(), false)) {
                    GuiConfigValueField.this.callback.onCallback(GuiConfigValueField.this.value, true);
                }
            }

            @Override
            public Color4I renderTitleInCenter(GuiBase gui) {
                return gui.getContentColor();
            }
        };
        this.buttonAccept.setIcon(Button.DEFAULT_BACKGROUND);
        this.textBox = new TextBox(2, 2, this.width - 4, 28){

            @Override
            public boolean isValid(String txt) {
                return GuiConfigValueField.this.value.setValueFromString(txt, true);
            }

            @Override
            public void onTextChanged(GuiBase gui) {
                ((GuiConfigValueField)GuiConfigValueField.this).textBox.textColor.set(GuiConfigValueField.this.value.getColor(), 255);
            }

            @Override
            public void onEnterPressed(GuiBase gui) {
                GuiConfigValueField.this.buttonAccept.onClicked(GuiConfigValueField.this, MouseButton.LEFT);
            }
        };
        this.textBox.writeText(this, val.toString());
        this.textBox.setFocused(true);
        this.textBox.background = Button.DEFAULT_BACKGROUND;
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonCancel);
        this.add(this.buttonAccept);
        this.add(this.textBox);
    }

    @Override
    public void drawBackground() {
        this.getIcon(this).draw(this, Color4I.NONE);
    }

    @Override
    public IDrawableObject getIcon(GuiBase gui) {
        return DEFAULT_BACKGROUND;
    }
}

