/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.client.FTBLibClient;
import com.feed_the_beast.ftbl.lib.util.LMNetUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.lwjgl.opengl.GL11;

public class GuiHelper {
    private static final int MAX_SCISSOR = 16;
    private static final int[] SCISSOR_X = new int[16];
    private static final int[] SCISSOR_Y = new int[16];
    private static final int[] SCISSOR_W = new int[16];
    private static final int[] SCISSOR_H = new int[16];
    private static int scissorIndex = -1;

    public static void playClickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public static void drawTexturedRect(int x, int y, int w, int h, Color4I col, double u0, double v0, double u1, double v1) {
        if (u0 == u1 || v0 == v1) {
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            GuiHelper.addRectToBuffer(buffer, x, y, w, h, col);
            tessellator.func_78381_a();
        } else {
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            GuiHelper.addRectToBufferWithUV(buffer, x, y, w, h, col, u0, v0, u1, v1);
            tessellator.func_78381_a();
        }
    }

    public static void drawBlankRect(int x, int y, int w, int h, Color4I col) {
        if (w <= 0 || h <= 0 || !col.hasColor()) {
            return;
        }
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiHelper.addRectToBuffer(buffer, x, y, w, h, col);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    private static void addRectToBuffer(VertexBuffer buffer, int x, int y, int w, int h, Color4I col) {
        buffer.func_181662_b((double)x, (double)(y + h), 0.0).func_181669_b(col.red(), col.green(), col.blue(), col.alpha()).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_181669_b(col.red(), col.green(), col.blue(), col.alpha()).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)y, 0.0).func_181669_b(col.red(), col.green(), col.blue(), col.alpha()).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181669_b(col.red(), col.green(), col.blue(), col.alpha()).func_181675_d();
    }

    private static void addRectToBufferWithUV(VertexBuffer buffer, int x, int y, int w, int h, Color4I col, double u0, double v0, double u1, double v1) {
        buffer.func_181662_b((double)x, (double)(y + h), 0.0).func_187315_a(u0, v1).func_181669_b(col.red(), col.green(), col.blue(), col.alpha()).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_187315_a(u1, v1).func_181669_b(col.red(), col.green(), col.blue(), col.alpha()).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)y, 0.0).func_187315_a(u1, v0).func_181669_b(col.red(), col.green(), col.blue(), col.alpha()).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(u0, v0).func_181669_b(col.red(), col.green(), col.blue(), col.alpha()).func_181675_d();
    }

    public static void drawHollowRect(int x, int y, int w, int h, Color4I col, boolean roundEdges) {
        if (w <= 1 || h <= 1 || !col.hasColor()) {
            GuiHelper.drawBlankRect(x, y, w, h, col);
            return;
        }
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiHelper.addRectToBuffer(buffer, x, y + 1, 1, h - 2, col);
        GuiHelper.addRectToBuffer(buffer, x + w - 1, y + 1, 1, h - 2, col);
        if (roundEdges) {
            GuiHelper.addRectToBuffer(buffer, x + 1, y, w - 2, 1, col);
            GuiHelper.addRectToBuffer(buffer, x + 1, y + h - 1, w - 2, 1, col);
        } else {
            GuiHelper.addRectToBuffer(buffer, x, y, w, 1, col);
            GuiHelper.addRectToBuffer(buffer, x, y + h - 1, w, 1, col);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    public static void drawCenteredString(FontRenderer font, String txt, float x, float y, Color4I color) {
        font.func_175065_a(txt, x - (float)(font.func_78256_a(txt) / 2), y - (float)font.field_78288_b / 2.0f, color.rgba(), false);
    }

    public static boolean drawItem(RenderItem itemRender, ItemStack stack, double x, double y, double scaleX, double scaleY, boolean renderOverlay) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        boolean result = true;
        itemRender.field_77023_b = 200.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)32.0);
        if (scaleX != 1.0 || scaleY != 1.0) {
            GlStateManager.func_179139_a((double)scaleX, (double)scaleY, (double)1.0);
        }
        GlStateManager.func_179145_e();
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        try {
            itemRender.func_180450_b(stack, 0, 0);
            if (renderOverlay) {
                FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
                if (font == null) {
                    font = Minecraft.func_71410_x().field_71466_p;
                }
                itemRender.func_180453_a(font, stack, 0, 0, null);
            }
        }
        catch (Exception ex) {
            result = false;
        }
        GlStateManager.func_179121_F();
        itemRender.field_77023_b = 0.0f;
        return result;
    }

    public static boolean drawItem(RenderItem itemRender, ItemStack stack, double x, double y, boolean renderOverlay) {
        return GuiHelper.drawItem(itemRender, stack, x, y, 1.0, 1.0, renderOverlay);
    }

    public static void pushScissor(ScaledResolution screen, int x, int y, int w, int h) {
        GuiHelper.pushScissor(screen, x, y, w, h, false);
    }

    public static void pushScissor(ScaledResolution screen, int x, int y, int w, int h, boolean ingorePrevious) {
        if (scissorIndex == -1) {
            GL11.glEnable((int)3089);
        } else if (!ingorePrevious) {
            // empty if block
        }
        if (++scissorIndex < 16) {
            int scale = screen.func_78325_e();
            GuiHelper.SCISSOR_X[GuiHelper.scissorIndex] = x * scale;
            GuiHelper.SCISSOR_Y[GuiHelper.scissorIndex] = (screen.func_78328_b() - y - h) * scale;
            GuiHelper.SCISSOR_W[GuiHelper.scissorIndex] = Math.max(w, 1) * scale;
            GuiHelper.SCISSOR_H[GuiHelper.scissorIndex] = Math.max(h, 1) * scale;
            GL11.glScissor((int)SCISSOR_X[scissorIndex], (int)SCISSOR_Y[scissorIndex], (int)SCISSOR_W[scissorIndex], (int)SCISSOR_H[scissorIndex]);
        }
    }

    public static void popScissor() {
        if (--scissorIndex == -1) {
            GL11.glDisable((int)3089);
        } else if (scissorIndex < 16) {
            GL11.glScissor((int)SCISSOR_X[scissorIndex], (int)SCISSOR_Y[scissorIndex], (int)SCISSOR_W[scissorIndex], (int)SCISSOR_H[scissorIndex]);
        }
    }

    public static void setFixUnicode(Minecraft mc, boolean enabled) {
        TextureManager textureManager = mc.func_110434_K();
        int mode = enabled ? 9729 : 9728;
        for (int i = 0; i < 256; ++i) {
            if (FontRenderer.field_111274_c[i] == null) continue;
            textureManager.func_110577_a(FontRenderer.field_111274_c[i]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)mode);
            GL11.glTexParameteri((int)3553, (int)10240, (int)mode);
        }
    }

    public static boolean onClickEvent(ClickEvent clickEvent) {
        switch (clickEvent.func_150669_a()) {
            case OPEN_URL: {
                try {
                    URI uri = new URI(clickEvent.func_150668_b());
                    String s = uri.getScheme();
                    if (s == null) {
                        throw new URISyntaxException(clickEvent.func_150668_b(), "Missing protocol");
                    }
                    if (!s.toLowerCase().contains("http") && !s.toLowerCase().contains("https")) {
                        throw new URISyntaxException(clickEvent.func_150668_b(), "Unsupported protocol: " + s.toLowerCase());
                    }
                    Minecraft mc = Minecraft.func_71410_x();
                    if (mc.field_71474_y.field_74358_q) {
                        GuiScreen currentScreen = mc.field_71462_r;
                        mc.func_147108_a((GuiScreen)new GuiConfirmOpenLink((result, id) -> {
                            if (result) {
                                try {
                                    LMNetUtils.openURI(uri);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            mc.func_147108_a(currentScreen);
                        }, clickEvent.func_150668_b(), 0, false));
                    } else {
                        LMNetUtils.openURI(uri);
                    }
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            case OPEN_FILE: {
                try {
                    LMNetUtils.openURI(new File(clickEvent.func_150668_b()).toURI());
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            case SUGGEST_COMMAND: {
                return true;
            }
            case RUN_COMMAND: {
                FTBLibClient.execClientCommand(clickEvent.func_150668_b(), true);
                return true;
            }
        }
        return false;
    }

    public static List<PositionedTextData> createDataFrom(ITextComponent component, FontRenderer font, int width) {
        if (width <= 0 || component.func_150260_c().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PositionedTextData> list = new ArrayList<PositionedTextData>();
        int line = 0;
        int currentWidth = 0;
        for (ITextComponent t : component.func_150259_f()) {
            String text = t.func_150261_e();
            int textWidth = font.func_78256_a(text);
            while (textWidth > 0) {
                int w = textWidth;
                if (w > width - currentWidth) {
                    w = width - currentWidth;
                }
                list.add(new PositionedTextData(currentWidth, line * 10, w, 10, t.func_150256_b()));
                textWidth -= w;
                if ((currentWidth += w) < width) continue;
                currentWidth = 0;
                ++line;
            }
        }
        return list;
    }

    public static class PositionedTextData {
        public final int posX;
        public final int posY;
        public final int width;
        public final int height;
        public final ClickEvent clickEvent;
        public final HoverEvent hoverEvent;
        public final String insertion;

        public PositionedTextData(int x, int y, int w, int h, Style s) {
            this.posX = x;
            this.posY = y;
            this.width = w;
            this.height = h;
            this.clickEvent = s.func_150235_h();
            this.hoverEvent = s.func_150210_i();
            this.insertion = s.func_179986_j();
        }
    }
}

