/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.ImmutableColor4I;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.client.TexturelessRectangle;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public class CheckBoxList
extends Button {
    public static final IDrawableObject DEFAULT_SELECTED_ICON = new TexturelessRectangle(new ImmutableColor4I(-2039584));
    public static final IDrawableObject DEFAULT_BACKGROUND = new TexturelessRectangle(new ImmutableColor4I(-7237231));
    public final boolean radioButtons;
    private final List<CheckBoxEntry> entries;
    public IDrawableObject background = DEFAULT_BACKGROUND;
    public IDrawableObject[] icons = new IDrawableObject[]{ImageProvider.NULL, DEFAULT_SELECTED_ICON};

    public CheckBoxList(int x, int y, boolean radiobutton) {
        super(x, y, 10, 2);
        this.radioButtons = radiobutton;
        this.entries = new ArrayList<CheckBoxEntry>();
    }

    public void addBox(GuiBase gui, CheckBoxEntry checkBox) {
        checkBox.checkBoxList = this;
        this.entries.add(checkBox);
        this.setWidth(Math.max(this.width, gui.getFont().func_78256_a(checkBox.name)));
        this.setHeight(this.height + 11);
    }

    public CheckBoxEntry addBox(GuiBase gui, String name) {
        CheckBoxEntry entry = new CheckBoxEntry(name);
        this.addBox(gui, entry);
        return entry;
    }

    @Override
    public void onClicked(GuiBase gui, IMouseButton button) {
        int y = gui.getMouseY() - this.getAY();
        if (y % 11 == 10) {
            return;
        }
        int i = y / 11;
        if (i >= 0 && i < this.entries.size()) {
            this.entries.get(i).onClicked(gui, button, i);
        }
    }

    @Override
    public void addMouseOverText(GuiBase gui, List<String> list) {
    }

    @Override
    public void renderWidget(GuiBase gui) {
        int ax = this.getAX();
        int ay = this.getAY();
        for (int i = 0; i < this.entries.size(); ++i) {
            CheckBoxEntry entry = this.entries.get(i);
            int y = ay + i * 11 + 1;
            this.background.draw(ax, y, 10, 10, Color4I.NONE);
            this.icons[entry.value].draw(ax + 1, y + 1, 8, 8, Color4I.NONE);
            gui.drawString(entry.name, ax + 12, y + 1);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static class CheckBoxEntry {
        public String name;
        public int value = 0;
        private CheckBoxList checkBoxList;

        public CheckBoxEntry(String n) {
            this.name = n;
        }

        public void onClicked(GuiBase gui, IMouseButton button, int index) {
            this.select((this.value + 1) % this.checkBoxList.icons.length);
            GuiHelper.playClickSound();
        }

        public void addMouseOverText(GuiBase gui, List<String> list) {
        }

        public CheckBoxEntry select(int v) {
            if (this.checkBoxList.radioButtons) {
                if (v > 0) {
                    for (CheckBoxEntry entry : this.checkBoxList.entries) {
                        boolean old1 = entry.value > 0;
                        entry.value = 0;
                        if (!old1) continue;
                        entry.onValueChanged();
                    }
                } else {
                    return this;
                }
            }
            int old = this.value;
            this.value = v;
            if (old != this.value) {
                this.onValueChanged();
            }
            return this;
        }

        public void onValueChanged() {
        }
    }
}

