/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.api.config.IConfigKey;
import com.feed_the_beast.ftbl.api.config.IConfigTree;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.config.ConfigKey;
import com.feed_the_beast.ftbl.lib.internal.FTBLibIntegrationInternal;
import com.feed_the_beast.ftbl.lib.util.LMNetUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ConfigTree
implements IConfigTree {
    private static final int HAS_DISPLAY_NAME = 1;
    private static final int HAS_INFO = 2;
    private final Map<IConfigKey, IConfigValue> tree;

    public ConfigTree(boolean linked) {
        this.tree = linked ? new LinkedHashMap() : new HashMap();
    }

    public ConfigTree() {
        this(false);
    }

    @Override
    public final Map<IConfigKey, IConfigValue> getTree() {
        return this.tree;
    }

    @Override
    public IConfigTree copy() {
        ConfigTree t = new ConfigTree();
        this.getTree().forEach((key, value) -> t.add((IConfigKey)key, value.copy()));
        return t;
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeShort(this.tree.size());
        this.tree.forEach((key, value) -> {
            String info;
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)key.func_176610_l());
            data.writeByte(key.getFlags());
            IConfigValue defValue = key.getDefValue();
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)defValue.func_176610_l());
            defValue.writeData(data);
            byte extraFlags = 0;
            ITextComponent rawDN = key.getRawDisplayName();
            if (rawDN != null) {
                extraFlags = (byte)(extraFlags | 1);
            }
            if (!(info = key.getInfo()).isEmpty()) {
                extraFlags = (byte)(extraFlags | 2);
            }
            data.writeByte((int)extraFlags);
            if (rawDN != null) {
                LMNetUtils.writeTextComponent(data, rawDN);
            }
            if (!info.isEmpty()) {
                ByteBufUtils.writeUTF8String((ByteBuf)data, (String)info);
            }
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)value.func_176610_l());
            value.writeData(data);
        });
    }

    @Override
    public void readData(ByteBuf data) {
        int s = data.readUnsignedShort();
        this.tree.clear();
        while (--s >= 0) {
            String id = ByteBufUtils.readUTF8String((ByteBuf)data);
            byte flags = data.readByte();
            IConfigValue value = FTBLibIntegrationInternal.API.getConfigValueFromID(ByteBufUtils.readUTF8String((ByteBuf)data));
            value.readData(data);
            ConfigKey key = new ConfigKey(id, value);
            key.setFlags(flags);
            byte extraFlags = data.readByte();
            if ((extraFlags & 1) != 0) {
                key.setDisplayName(LMNetUtils.readTextComponent(data));
            }
            if ((extraFlags & 2) != 0) {
                key.setInfo(ByteBufUtils.readUTF8String((ByteBuf)data));
            }
            value = FTBLibIntegrationInternal.API.getConfigValueFromID(ByteBufUtils.readUTF8String((ByteBuf)data));
            value.readData(data);
            this.tree.put(key, value);
        }
    }

    public void func_152753_a(JsonElement json) {
        JsonObject o = json.getAsJsonObject();
        this.getTree().forEach((key, value) -> {
            JsonElement e;
            if (!key.getFlag(1) && (e = o.get(key.func_176610_l())) != null) {
                value.func_152753_a(e);
            }
        });
    }

    public JsonElement func_151003_a() {
        JsonObject o = new JsonObject();
        this.tree.forEach((key, value) -> {
            if (!key.getFlag(1)) {
                o.add(key.func_176610_l(), value.func_151003_a());
            }
        });
        return o;
    }
}

