/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.client;

import com.feed_the_beast.ftbl.lib.client.CachedVertexData;
import com.feed_the_beast.ftbl.lib.math.MathHelperLM;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class CubeBuilder {
    private final CachedVertexData data;
    private final List<Face> faces;
    private double minX;
    private double minY;
    private double minZ;
    private double maxX;
    private double maxY;
    private double maxZ;
    private double minU;
    private double minV;
    private double maxU;
    private double maxV;

    public CubeBuilder(VertexFormat f) {
        this.data = new CachedVertexData(7, f);
        this.faces = new ArrayList<Face>();
    }

    public CubeBuilder setSize(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.minX = x0;
        this.minY = y0;
        this.minZ = z0;
        this.maxX = x1;
        this.maxY = y1;
        this.maxZ = z1;
        return this;
    }

    public CubeBuilder setSize(AxisAlignedBB aabb) {
        return this.setSize(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public CubeBuilder setSizeWHD(double x, double y, double z, double w, double h, double d) {
        return this.setSize(x, y, z, x + w, y + h, z + d);
    }

    public CubeBuilder add(EnumFacing facing) {
        float normalX = MathHelperLM.NORMALS_X[facing.func_176745_a()];
        float normalY = MathHelperLM.NORMALS_Y[facing.func_176745_a()];
        float normalZ = MathHelperLM.NORMALS_Z[facing.func_176745_a()];
        switch (facing) {
            case DOWN: {
                this.data.pos(this.minX, this.minY, this.minZ).tex(this.minU, this.minV).normal(normalX, normalY, normalZ);
                this.data.pos(this.maxX, this.minY, this.minZ).tex(this.maxU, this.minV).normal(normalX, normalY, normalZ);
                this.data.pos(this.maxX, this.minY, this.maxZ).tex(this.maxU, this.maxV).normal(normalX, normalY, normalZ);
                this.data.pos(this.minX, this.minY, this.maxZ).tex(this.minU, this.maxV).normal(normalX, normalY, normalZ);
                break;
            }
            case UP: {
                this.data.pos(this.minX, this.maxY, this.minZ).tex(this.minU, this.minV).normal(normalX, normalY, normalZ);
                this.data.pos(this.minX, this.maxY, this.maxZ).tex(this.minU, this.maxV).normal(normalX, normalY, normalZ);
                this.data.pos(this.maxX, this.maxY, this.maxZ).tex(this.maxU, this.maxV).normal(normalX, normalY, normalZ);
                this.data.pos(this.maxX, this.maxY, this.minZ).tex(this.maxU, this.minV).normal(normalX, normalY, normalZ);
                break;
            }
            case NORTH: {
                this.data.pos(this.minX, this.minY, this.minZ).tex(this.maxU, this.maxV).normal(normalX, normalY, normalZ);
                this.data.pos(this.minX, this.maxY, this.minZ).tex(this.maxU, this.minV).normal(normalX, normalY, normalZ);
                this.data.pos(this.maxX, this.maxY, this.minZ).tex(this.minU, this.minV).normal(normalX, normalY, normalZ);
                this.data.pos(this.maxX, this.minY, this.minZ).tex(this.minU, this.maxV).normal(normalX, normalY, normalZ);
                break;
            }
            case SOUTH: {
                this.data.pos(this.minX, this.minY, this.maxZ).tex(this.minU, this.maxV).normal(normalX, normalY, normalZ);
                this.data.pos(this.maxX, this.minY, this.maxZ).tex(this.maxU, this.maxV).normal(normalX, normalY, normalZ);
                this.data.pos(this.maxX, this.maxY, this.maxZ).tex(this.maxU, this.minV).normal(normalX, normalY, normalZ);
                this.data.pos(this.minX, this.maxY, this.maxZ).tex(this.minU, this.minV).normal(normalX, normalY, normalZ);
                break;
            }
            case WEST: {
                this.data.pos(this.minX, this.minY, this.minZ).tex(this.minU, this.maxV).normal(normalX, normalY, normalZ);
                this.data.pos(this.minX, this.minY, this.maxZ).tex(this.maxU, this.maxV).normal(normalX, normalY, normalZ);
                this.data.pos(this.minX, this.maxY, this.maxZ).tex(this.maxU, this.minV).normal(normalX, normalY, normalZ);
                this.data.pos(this.minX, this.maxY, this.minZ).tex(this.minU, this.minV).normal(normalX, normalY, normalZ);
                break;
            }
            case EAST: {
                this.data.pos(this.maxX, this.minY, this.minZ).tex(this.maxU, this.maxV).normal(normalX, normalY, normalZ);
                this.data.pos(this.maxX, this.maxY, this.minZ).tex(this.maxU, this.minV).normal(normalX, normalY, normalZ);
                this.data.pos(this.maxX, this.maxY, this.maxZ).tex(this.minU, this.minV).normal(normalX, normalY, normalZ);
                this.data.pos(this.maxX, this.minY, this.maxZ).tex(this.minU, this.maxV).normal(normalX, normalY, normalZ);
            }
        }
        return this;
    }

    public CubeBuilder addAll() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.add(facing);
        }
        return this;
    }

    public CubeBuilder addSides() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (facing.func_176740_k() == EnumFacing.Axis.Y) continue;
            this.add(facing);
        }
        return this;
    }

    public CachedVertexData build() {
        return this.data.copy();
    }

    public void setUV(double u0, double v0, double u1, double v1) {
        this.minU = u0;
        this.minV = v0;
        this.maxU = u1;
        this.maxV = v1;
    }

    public static class Face {
        private EnumFacing facing;

        private Face(EnumFacing f) {
            this.facing = f;
        }
    }
}

