/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.client;

import com.feed_the_beast.ftbl.lib.Color4I;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;

public class CachedVertexData {
    private final int mode;
    private final VertexFormat format;
    private final List<CachedVertex> list;
    private final boolean hasTex;
    private final boolean hasColor;
    private final boolean hasNormal;
    public final Color4I color;

    private CachedVertexData(int m, VertexFormat f, Collection<CachedVertex> oldList) {
        this.mode = m;
        this.format = f;
        this.list = new ArrayList<CachedVertex>(oldList);
        this.hasTex = f.func_177347_a(0);
        this.hasColor = f.func_177346_d();
        this.hasNormal = f.func_177350_b();
        this.color = new Color4I();
    }

    public CachedVertexData(int m, VertexFormat f) {
        this(m, f, Collections.emptyList());
    }

    public void reset() {
        this.list.clear();
    }

    public CachedVertexData copy() {
        return new CachedVertexData(this.mode, this.format, this.list);
    }

    public CachedVertex pos(double x, double y, double z) {
        CachedVertex v = new CachedVertex(x, y, z);
        this.list.add(v);
        return v;
    }

    public CachedVertex pos(double x, double y) {
        return this.pos(x, y, 0.0);
    }

    public void draw(Tessellator tessellator, VertexBuffer buffer) {
        if (this.list.isEmpty()) {
            return;
        }
        buffer.func_181668_a(this.mode, this.format);
        for (CachedVertex v : this.list) {
            v.appendTo(buffer);
        }
        tessellator.func_78381_a();
    }

    public void rect(int x, int y, int w, int h) {
        this.pos(x, y + h, 0.0);
        this.pos(x + w, y + h, 0.0);
        this.pos(x + w, y, 0.0);
        this.pos(x, y, 0.0);
    }

    public void rectWithTexture(int x, int y, int w, int h, double u0, double v0, double u1, double v1) {
        this.pos(x, y + h, 0.0).tex(u0, v1);
        this.pos(x + w, y + h, 0.0).tex(u1, v1);
        this.pos(x + w, y, 0.0).tex(u1, v0);
        this.pos(x, y, 0.0).tex(u0, v0);
    }

    public class CachedVertex {
        private double x;
        private double y;
        private double z;
        private double u;
        private double v;
        private int r;
        private int g;
        private int b;
        private int a;
        private float nx;
        private float ny;
        private float nz;

        private CachedVertex(double _x, double _y, double _z) {
            this.r = CachedVertexData.this.color.red();
            this.g = CachedVertexData.this.color.green();
            this.b = CachedVertexData.this.color.blue();
            this.a = CachedVertexData.this.color.alpha();
            this.x = _x;
            this.y = _y;
            this.z = _z;
        }

        public CachedVertex tex(double _u, double _v) {
            this.u = _u;
            this.v = _v;
            return this;
        }

        public CachedVertex color(int _r, int _g, int _b, int _a) {
            this.r = _r;
            this.g = _g;
            this.b = _b;
            this.a = _a;
            return this;
        }

        public CachedVertex normal(float x, float y, float z) {
            this.nx = x;
            this.ny = y;
            this.nz = z;
            return this;
        }

        private void appendTo(VertexBuffer buffer) {
            buffer.func_181662_b(this.x, this.y, this.z);
            if (CachedVertexData.this.hasTex) {
                buffer.func_187315_a(this.u, this.v);
            }
            if (CachedVertexData.this.hasColor) {
                buffer.func_181669_b(this.r, this.g, this.b, this.a);
            }
            if (CachedVertexData.this.hasNormal) {
                buffer.func_181663_c(this.nx, this.ny, this.nz);
            }
            buffer.func_181675_d();
        }
    }
}

