/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib;

import com.feed_the_beast.ftbl.lib.ImmutableColor4I;
import com.feed_the_beast.ftbl.lib.util.LMColorUtils;
import com.google.gson.JsonElement;
import net.minecraft.util.math.MathHelper;

public class Color4I {
    public static final Color4I NONE = new ImmutableColor4I(0);
    public static final Color4I BLACK = new ImmutableColor4I(-16777216);
    public static final Color4I DARK_GRAY = new ImmutableColor4I(-14606047);
    public static final Color4I GRAY = new ImmutableColor4I(-6710887);
    public static final Color4I WHITE = new ImmutableColor4I(-1);
    public static final Color4I WHITE_A33 = new ImmutableColor4I(0x21FFFFFF);
    public static final Color4I RED = new ImmutableColor4I(-65536);
    public static final Color4I LIGHT_RED = new ImmutableColor4I(-43434);
    private int red = 255;
    private int green = 255;
    private int blue = 255;
    private int alpha = 255;
    private int rgba = -1;

    public Color4I() {
    }

    public Color4I(int r, int g, int b, int a) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.alpha = a;
        this.rgba = LMColorUtils.getRGBA(this.red, this.green, this.blue, this.alpha);
    }

    public Color4I(int col) {
        this.red = LMColorUtils.getRed(col);
        this.green = LMColorUtils.getGreen(col);
        this.blue = LMColorUtils.getBlue(col);
        this.alpha = LMColorUtils.getAlpha(col);
        this.rgba = col;
    }

    public Color4I(Color4I col) {
        this(col.red, col.green, col.blue, col.alpha);
    }

    protected boolean canSetColor(int r, int g, int b, int a) {
        return true;
    }

    protected void onColorSet() {
    }

    public final Color4I set(int r, int g, int b, int a) {
        if (this.canSetColor(r, g, b, a)) {
            this.red = r;
            this.green = g;
            this.blue = b;
            this.alpha = a;
            this.rgba = LMColorUtils.getRGBA(this.red, this.green, this.blue, this.alpha);
            this.onColorSet();
        }
        return this;
    }

    public final Color4I set(Color4I col, int a) {
        return this.set(col.red, col.green, col.blue, a);
    }

    public final Color4I set(Color4I col) {
        return this.set(col, col.alpha);
    }

    public final Color4I set(int col, int a) {
        return this.set(LMColorUtils.getRed(col), LMColorUtils.getGreen(col), LMColorUtils.getBlue(col), a);
    }

    public final Color4I set(int col) {
        return this.set(col, LMColorUtils.getAlpha(col));
    }

    public final int red() {
        return this.red;
    }

    public final int green() {
        return this.green;
    }

    public final int blue() {
        return this.blue;
    }

    public final int alpha() {
        return this.alpha;
    }

    public final float redf() {
        return (float)this.red / 255.0f;
    }

    public final float greenf() {
        return (float)this.green / 255.0f;
    }

    public final float bluef() {
        return (float)this.blue / 255.0f;
    }

    public final float alphaf() {
        return (float)this.alpha / 255.0f;
    }

    public final int rgba() {
        return this.rgba;
    }

    public final boolean hasColor() {
        return this.alpha > 0;
    }

    public final Color4I copy(boolean immutable, int a) {
        return immutable ? new ImmutableColor4I(this.red, this.green, this.blue, a) : new Color4I(this.red, this.green, this.blue, a);
    }

    public final Color4I copy(boolean immutable) {
        return this.copy(immutable, this.alpha);
    }

    public final int hashCode() {
        return this.rgba();
    }

    public final boolean equals(Object o) {
        return o == this || o != null && o.hashCode() == this.rgba();
    }

    public final String toString() {
        return LMColorUtils.getHex(this.rgba());
    }

    public final JsonElement toJson() {
        return LMColorUtils.serialize(this.rgba());
    }

    public void addBrightness(int b) {
        this.set(MathHelper.func_76125_a((int)(this.red + b), (int)0, (int)255), MathHelper.func_76125_a((int)(this.green + b), (int)0, (int)255), MathHelper.func_76125_a((int)(this.blue + b), (int)0, (int)255), this.alpha);
    }
}

