/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client.teamsgui;

import com.feed_the_beast.ftbl.api.EnumTeamColor;
import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.client.FTBLibClient;
import com.feed_the_beast.ftbl.lib.client.TexturelessRectangle;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.TextBox;
import com.feed_the_beast.ftbl.lib.math.MathHelperLM;
import com.feed_the_beast.ftbl.lib.util.LMStringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class GuiCreateTeam
extends GuiBase {
    private EnumTeamColor color = EnumTeamColor.VALUES[MathHelperLM.RAND.nextInt(EnumTeamColor.VALUES.length)];
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final List<Button> colorButtons;
    private final TextBox textBoxId;

    public GuiCreateTeam() {
        super(154, 102);
        int bwidth = this.width / 2 - 6;
        this.buttonAccept = new Button(this.width - bwidth - 4, this.height - 20, bwidth, 16){

            @Override
            public void onClicked(GuiBase gui, IMouseButton button) {
                GuiHelper.playClickSound();
                if (!GuiCreateTeam.this.textBoxId.getText().isEmpty()) {
                    FTBLibClient.execClientCommand("/ftb team create " + GuiCreateTeam.this.textBoxId.getText() + " " + GuiCreateTeam.this.color.func_176610_l());
                    gui.closeGui();
                }
            }

            @Override
            public Color4I renderTitleInCenter(GuiBase gui) {
                return gui.getContentColor();
            }
        };
        this.buttonAccept.setTitle(GuiLang.BUTTON_ACCEPT.translate(new Object[0]));
        this.buttonAccept.setIcon(Button.DEFAULT_BACKGROUND);
        this.buttonCancel = new Button(4, this.height - 20, bwidth, 16){

            @Override
            public void onClicked(GuiBase gui, IMouseButton button) {
                GuiHelper.playClickSound();
                gui.closeGui();
            }

            @Override
            public Color4I renderTitleInCenter(GuiBase gui) {
                return gui.getContentColor();
            }
        };
        this.buttonCancel.setTitle(GuiLang.BUTTON_CANCEL.translate(new Object[0]));
        this.buttonCancel.setIcon(Button.DEFAULT_BACKGROUND);
        this.textBoxId = new TextBox(4, 4, this.width - 8, 16){

            @Override
            public void onTextChanged(GuiBase gui) {
                this.setText(gui, LMStringUtils.getID(this.getText(), 14), false);
            }
        };
        this.textBoxId.writeText(this, this.mc.field_71439_g.func_146103_bH().getName().toLowerCase());
        this.textBoxId.background = Button.DEFAULT_BACKGROUND;
        this.textBoxId.ghostText = TextFormatting.ITALIC.toString() + TextFormatting.DARK_GRAY + "Enter ID";
        this.textBoxId.textColor = this.color.getColor();
        this.textBoxId.setFocused(true);
        this.textBoxId.charLimit = 35;
        this.colorButtons = new ArrayList<Button>();
        for (int i = 0; i < EnumTeamColor.VALUES.length; ++i) {
            final int i1 = i;
            Button b = new Button(4 + i % 5 * 30, 24 + i / 5 * 30, 25, 25){

                @Override
                public void onClicked(GuiBase gui, IMouseButton button) {
                    GuiCreateTeam.this.color = EnumTeamColor.VALUES[i1];
                    ((GuiCreateTeam)GuiCreateTeam.this).textBoxId.textColor = GuiCreateTeam.this.color.getColor();
                }
            };
            b.setIcon(new TexturelessRectangle(EnumTeamColor.VALUES[i].getColor()).setLineColor(GuiCreateTeam.DEFAULT_BACKGROUND.lineColor).setRoundEdges(true));
            b.setTitle(EnumTeamColor.VALUES[i].getTextFormatting() + EnumTeamColor.VALUES[i].getLangKey().translate(new Object[0]));
            this.colorButtons.add(b);
        }
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        this.addAll(this.colorButtons);
        this.add(this.textBoxId);
    }

    @Override
    public IDrawableObject getIcon(GuiBase gui) {
        return DEFAULT_BACKGROUND;
    }
}

