/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api_impl;

import com.feed_the_beast.ftbl.FTBLibConfig;
import com.feed_the_beast.ftbl.FTBLibMod;
import com.feed_the_beast.ftbl.FTBLibModCommon;
import com.feed_the_beast.ftbl.api.EnumTeamColor;
import com.feed_the_beast.ftbl.api.EnumTeamStatus;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.api.ITeamMessage;
import com.feed_the_beast.ftbl.api.config.IConfigKey;
import com.feed_the_beast.ftbl.api.config.IConfigTree;
import com.feed_the_beast.ftbl.api.events.team.ForgeTeamDeletedEvent;
import com.feed_the_beast.ftbl.api.events.team.ForgeTeamOwnerChangedEvent;
import com.feed_the_beast.ftbl.api.events.team.ForgeTeamPlayerJoinedEvent;
import com.feed_the_beast.ftbl.api.events.team.ForgeTeamPlayerLeftEvent;
import com.feed_the_beast.ftbl.api.events.team.ForgeTeamSettingsEvent;
import com.feed_the_beast.ftbl.api_impl.ForgePlayerFake;
import com.feed_the_beast.ftbl.api_impl.Universe;
import com.feed_the_beast.ftbl.lib.EnumNameMap;
import com.feed_the_beast.ftbl.lib.FinalIDObject;
import com.feed_the_beast.ftbl.lib.NBTDataStorage;
import com.feed_the_beast.ftbl.lib.config.ConfigKey;
import com.feed_the_beast.ftbl.lib.config.ConfigTree;
import com.feed_the_beast.ftbl.lib.config.PropertyBool;
import com.feed_the_beast.ftbl.lib.config.PropertyEnum;
import com.feed_the_beast.ftbl.lib.config.PropertyString;
import com.feed_the_beast.ftbl.lib.internal.FTBLibIntegrationInternal;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbl.lib.internal.FTBLibNotifications;
import com.feed_the_beast.ftbl.lib.io.Bits;
import com.feed_the_beast.ftbl.lib.util.LMNetUtils;
import com.feed_the_beast.ftbl.lib.util.LMServerUtils;
import com.feed_the_beast.ftbl.lib.util.LMStringUtils;
import com.feed_the_beast.ftbl.net.MessageDisplayTeamMsg;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class ForgeTeam
extends FinalIDObject
implements IForgeTeam {
    private static final IConfigKey KEY_COLOR = new ConfigKey("display.color", new PropertyEnum<EnumTeamColor>(EnumTeamColor.NAME_MAP, EnumTeamColor.BLUE), (ITextComponent)new TextComponentTranslation("ftbteam.config.display.color", new Object[0]));
    private static final IConfigKey KEY_TITLE = new ConfigKey("display.title", new PropertyString("", 30), (ITextComponent)new TextComponentTranslation("ftbteam.config.display.title", new Object[0]));
    private static final IConfigKey KEY_DESC = new ConfigKey("display.desc", new PropertyString("", 100), (ITextComponent)new TextComponentTranslation("ftbteam.config.display.desc", new Object[0]));
    private static final IConfigKey KEY_FREE_TO_JOIN = new ConfigKey("free_to_join", new PropertyBool(false), (ITextComponent)new TextComponentTranslation("ftbteam.config.free_to_join", new Object[0]));
    private final NBTDataStorage dataStorage;
    private EnumTeamColor color = EnumTeamColor.BLUE;
    private IForgePlayer owner;
    private String title = "";
    private String desc = "";
    private int flags = 0;
    private List<ITeamMessage> chatHistory;
    private Map<UUID, EnumTeamStatus> players;
    private IConfigTree cachedConfig;

    public ForgeTeam(String id) {
        super(id);
        this.dataStorage = FTBLibMod.PROXY.createDataStorage(this, FTBLibModCommon.DATA_PROVIDER_TEAM);
    }

    @Override
    @Nullable
    public INBTSerializable<?> getData(ResourceLocation id) {
        return this.dataStorage == null ? null : this.dataStorage.get(id);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Owner", LMStringUtils.fromUUID(this.owner.getId()));
        nbt.func_74774_a("Flags", (byte)this.flags);
        nbt.func_74778_a("Color", EnumNameMap.getName((Object)this.color));
        if (!this.title.isEmpty()) {
            nbt.func_74778_a("Title", this.title);
        }
        if (!this.desc.isEmpty()) {
            nbt.func_74778_a("Desc", this.desc);
        }
        if (this.players != null && !this.players.isEmpty()) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            for (Map.Entry<UUID, EnumTeamStatus> entry : this.players.entrySet()) {
                nbt1.func_74778_a(LMStringUtils.fromUUID(entry.getKey()), entry.getValue().func_176610_l());
            }
            nbt.func_74782_a("Players", (NBTBase)nbt1);
        }
        if (this.dataStorage != null) {
            nbt.func_74782_a("Data", (NBTBase)this.dataStorage.serializeNBT());
        }
        if (this.chatHistory != null && !this.chatHistory.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (ITeamMessage msg : this.chatHistory) {
                list.func_74742_a((NBTBase)Message.toNBT(msg));
            }
            nbt.func_74782_a("Chat", (NBTBase)list);
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList list;
        this.owner = Universe.INSTANCE.getPlayer(LMStringUtils.fromString(nbt.func_74779_i("Owner")));
        this.flags = nbt.func_74762_e("Flags");
        this.color = EnumTeamColor.NAME_MAP.get(nbt.func_74779_i("Color"));
        this.title = nbt.func_74779_i("Title");
        this.desc = nbt.func_74779_i("Desc");
        if (this.players != null) {
            this.players.clear();
        }
        if (nbt.func_74764_b("Players")) {
            if (this.players == null) {
                this.players = new HashMap<UUID, EnumTeamStatus>();
            }
            NBTTagCompound nbt1 = nbt.func_74775_l("Players");
            for (String s : nbt1.func_150296_c()) {
                EnumTeamStatus status;
                UUID id = LMStringUtils.fromString(s);
                if (id == null || (status = EnumTeamStatus.NAME_MAP.get(nbt1.func_74779_i(s))) == null || !status.canBeSet()) continue;
                this.players.put(id, status);
            }
        }
        if (nbt.func_74764_b("Invited")) {
            if (this.players == null) {
                this.players = new HashMap<UUID, EnumTeamStatus>();
            }
            list = nbt.func_150295_c("Invited", 8);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                UUID id = LMStringUtils.fromString(list.func_150307_f(i));
                if (id == null || this.players.containsKey(id)) continue;
                this.players.put(id, EnumTeamStatus.INVITED);
            }
        }
        if (this.dataStorage != null) {
            this.dataStorage.deserializeNBT(nbt.func_74764_b("Caps") ? nbt.func_74775_l("Caps") : nbt.func_74775_l("Data"));
        }
        if (this.chatHistory != null) {
            this.chatHistory.clear();
        }
        if (nbt.func_74764_b("Chat")) {
            if (this.chatHistory == null) {
                this.chatHistory = new ArrayList<ITeamMessage>();
            }
            list = nbt.func_150295_c("Chat", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.chatHistory.add(new Message(list.func_150305_b(i)));
            }
        }
    }

    @Override
    public IForgePlayer getOwner() {
        return this.owner;
    }

    @Override
    public String getTitle() {
        return this.title.isEmpty() ? this.owner.getName() + (this.owner.getName().endsWith("s") ? "' Team" : "'s Team") : this.title;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public EnumTeamColor getColor() {
        return this.color;
    }

    public void setColor(EnumTeamColor col) {
        this.color = col;
    }

    @Override
    public EnumTeamStatus getHighestStatus(UUID playerId) {
        if (this.owner.getId().equals(playerId)) {
            return EnumTeamStatus.OWNER;
        }
        EnumTeamStatus status = this.getSetStatus(playerId);
        if (status == EnumTeamStatus.MOD) {
            if (!this.isMember(playerId)) {
                status = EnumTeamStatus.NONE;
            }
        } else if (!status.isEqualOrGreaterThan(EnumTeamStatus.MEMBER) && this.isMember(playerId)) {
            status = EnumTeamStatus.MEMBER;
        }
        return status;
    }

    private boolean isMember(UUID playerId) {
        IForgePlayer player = FTBLibIntegrationInternal.API.getUniverse().getPlayer(playerId);
        return player != null && this.equals(player.getTeam());
    }

    private EnumTeamStatus getSetStatus(UUID playerId) {
        if (this.players == null || this.players.isEmpty()) {
            return EnumTeamStatus.NONE;
        }
        EnumTeamStatus status = this.players.get(playerId);
        if (status == null) {
            status = EnumTeamStatus.NONE;
            if (Bits.getFlag(this.flags, 1)) {
                status = EnumTeamStatus.INVITED;
            }
        }
        return status;
    }

    @Override
    public boolean hasStatus(UUID playerId, EnumTeamStatus status) {
        if (status.isNone()) {
            return true;
        }
        EnumTeamStatus status1 = this.getHighestStatus(playerId);
        return status1.isEqualOrGreaterThan(status);
    }

    @Override
    public void setStatus(UUID playerId, EnumTeamStatus status) {
        if (status.canBeSet() && !status.isNone()) {
            if (this.players == null) {
                this.players = new HashMap<UUID, EnumTeamStatus>();
            }
            this.players.put(playerId, status);
        } else if (this.players != null) {
            this.players.remove(playerId);
        }
    }

    @Override
    public Collection<IForgePlayer> getPlayersWithStatus(Collection<IForgePlayer> c, EnumTeamStatus status) {
        for (IForgePlayer iForgePlayer : Universe.INSTANCE.getPlayers()) {
            if (!this.hasStatus(iForgePlayer, status)) continue;
            c.add(iForgePlayer);
        }
        return c;
    }

    @Override
    public boolean addPlayer(IForgePlayer player) {
        if (this.hasStatus(player, EnumTeamStatus.INVITED)) {
            player.setTeamID(this.func_176610_l());
            if (!this.hasStatus(player, EnumTeamStatus.MEMBER)) {
                MinecraftForge.EVENT_BUS.post((Event)new ForgeTeamPlayerJoinedEvent(this, player));
                this.setStatus(player.getId(), EnumTeamStatus.MEMBER);
                this.printMessage(new Message(FTBLibLang.TEAM_MEMBER_JOINED.textComponent(player.getName())));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removePlayer(IForgePlayer player) {
        if (this.getPlayersWithStatus(new ArrayList<IForgePlayer>(), EnumTeamStatus.MEMBER).size() == 1) {
            this.printMessage(new Message(FTBLibLang.TEAM_DELETED.textComponent(this.getTitle())));
            MinecraftForge.EVENT_BUS.post((Event)new ForgeTeamDeletedEvent(this));
            this.removePlayer0(player);
            Universe.INSTANCE.teams.remove(this.func_176610_l());
        } else {
            if (this.hasStatus(player, EnumTeamStatus.OWNER)) {
                return false;
            }
            this.removePlayer0(player);
        }
        return true;
    }

    private void removePlayer0(IForgePlayer player) {
        if (this.hasStatus(player, EnumTeamStatus.MEMBER)) {
            player.setTeamID("");
            MinecraftForge.EVENT_BUS.post((Event)new ForgeTeamPlayerLeftEvent(this, player));
            this.printMessage(new Message(FTBLibLang.TEAM_MEMBER_LEFT.textComponent(player.getName())));
        }
    }

    @Override
    public void changeOwner(IForgePlayer newOwner) {
        if (this.owner == null) {
            this.owner = newOwner;
            newOwner.setTeamID(this.func_176610_l());
        } else {
            IForgePlayer oldOwner = this.owner;
            if (!oldOwner.equalsPlayer(newOwner) && this.hasStatus(newOwner, EnumTeamStatus.MEMBER)) {
                this.owner = newOwner;
                MinecraftForge.EVENT_BUS.post((Event)new ForgeTeamOwnerChangedEvent(this, oldOwner, newOwner));
            }
        }
    }

    @Override
    public IConfigTree getSettings() {
        if (this.cachedConfig != null) {
            return this.cachedConfig;
        }
        this.cachedConfig = new ConfigTree();
        MinecraftForge.EVENT_BUS.post((Event)new ForgeTeamSettingsEvent(this, this.cachedConfig));
        this.cachedConfig.add(KEY_COLOR, new PropertyEnum<EnumTeamColor>(EnumTeamColor.NAME_MAP, EnumTeamColor.BLUE){

            @Override
            public EnumTeamColor get() {
                return ForgeTeam.this.color;
            }

            @Override
            public void set(@Nullable EnumTeamColor e) {
                ForgeTeam.this.color = e == null ? EnumTeamColor.BLUE : e;
            }
        });
        this.cachedConfig.add(KEY_TITLE, new PropertyString(""){

            @Override
            public void setString(String v) {
                ForgeTeam.this.title = v.trim();
            }

            @Override
            public String getString() {
                return ForgeTeam.this.title;
            }
        });
        this.cachedConfig.add(KEY_DESC, new PropertyString(""){

            @Override
            public void setString(String v) {
                ForgeTeam.this.desc = v.trim();
            }

            @Override
            public String getString() {
                return ForgeTeam.this.desc;
            }
        });
        this.cachedConfig.add(KEY_FREE_TO_JOIN, new PropertyBool(false){

            @Override
            public boolean getBoolean() {
                return Bits.getFlag(ForgeTeam.this.flags, 1);
            }

            @Override
            public void setBoolean(boolean v) {
                ForgeTeam.this.flags = Bits.setFlag(ForgeTeam.this.flags, 1, v);
            }
        });
        return this.cachedConfig;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public void printMessage(ITeamMessage message) {
        if (this.chatHistory == null) {
            this.chatHistory = new ArrayList<ITeamMessage>();
        }
        while (this.chatHistory.size() >= FTBLibConfig.MAX_TEAM_CHAT_HISTORY.getInt()) {
            this.chatHistory.remove(0);
        }
        this.chatHistory.add(message);
        MessageDisplayTeamMsg m = new MessageDisplayTeamMsg(message);
        for (EntityPlayerMP ep : this.getOnlineTeamPlayers(EnumTeamStatus.MEMBER)) {
            if (!ep.func_146103_bH().getId().equals(message.getSender()) && !Bits.getFlag(Universe.INSTANCE.getPlayer(ep).getFlags(), 2)) {
                FTBLibIntegrationInternal.API.sendNotification((EntityPlayer)ep, FTBLibNotifications.NEW_TEAM_MESSAGE);
            }
            m.sendTo((EntityPlayer)ep);
        }
    }

    @Override
    public List<ITeamMessage> getMessages() {
        return this.chatHistory == null ? Collections.emptyList() : this.chatHistory;
    }

    public Collection<EntityPlayerMP> getOnlineTeamPlayers(EnumTeamStatus status) {
        ArrayList<EntityPlayerMP> list = new ArrayList<EntityPlayerMP>();
        for (EntityPlayerMP ep : LMServerUtils.getServer().func_184103_al().func_181057_v()) {
            if (!this.hasStatus(ep.func_146103_bH().getId(), status)) continue;
            list.add(ep);
        }
        return list;
    }

    @Override
    public boolean isValid() {
        return !Bits.getFlag(this.flags, 2);
    }

    public static class Message
    implements ITeamMessage {
        private final UUID sender;
        private final long time;
        private final ITextComponent text;

        public Message(UUID s, long t, ITextComponent txt) {
            this.sender = s;
            this.time = t;
            this.text = txt;
        }

        public Message(ITextComponent txt) {
            this(ForgePlayerFake.SERVER.getId(), System.currentTimeMillis(), txt);
        }

        public Message(NBTTagCompound nbt) {
            this.sender = nbt.func_186857_a("Sender");
            this.time = nbt.func_74763_f("Time");
            String m = nbt.func_74779_i("Msg");
            this.text = m.isEmpty() ? ForgeHooks.newChatWithLinks((String)nbt.func_74779_i("Text")) : ITextComponent.Serializer.func_150699_a((String)m);
        }

        public Message(ByteBuf io) {
            this.sender = LMNetUtils.readUUID(io);
            this.time = io.readLong();
            this.text = LMNetUtils.readTextComponent(io);
        }

        public static NBTTagCompound toNBT(ITeamMessage msg) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_186854_a("Sender", msg.getSender());
            nbt.func_74772_a("Time", msg.getTime());
            nbt.func_74778_a("Msg", ITextComponent.Serializer.func_150696_a((ITextComponent)msg.getMessage()));
            return nbt;
        }

        public static void write(ByteBuf io, ITeamMessage msg) {
            LMNetUtils.writeUUID(io, msg.getSender());
            io.writeLong(msg.getTime());
            LMNetUtils.writeTextComponent(io, msg.getMessage());
        }

        @Override
        public int compareTo(ITeamMessage o) {
            return Long.compare(this.getTime(), o.getTime());
        }

        @Override
        public UUID getSender() {
            return this.sender;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public ITextComponent getMessage() {
            return this.text;
        }
    }
}

