/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.sound;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.lib.LibLog;
import org.blockartistry.lib.sound.MemoryStreamHandler;
import org.blockartistry.lib.sound.SoundStreamHandler;

@SideOnly(value=Side.CLIENT)
public final class SoundCache {
    private static final int BUFFER_SIZE = 65536;
    private static final byte[] BUFFER = new byte[65536];
    private static final IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
    private static final Map<ResourceLocation, URL> cache = new HashMap<ResourceLocation, URL>(256);
    private static final ResourceLocation SILENCE_RESOURCE = new ResourceLocation("dsurround", "sounds/ambient/silence.ogg");
    private static final byte[] SILENCE = SoundCache.getBuffer(SILENCE_RESOURCE);
    private static URL SILENCE_URL;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getBuffer(@Nonnull ResourceLocation resource) {
        try (InputStream stream = manager.func_110536_a(resource).func_110527_b();){
            if (stream == null) {
                LibLog.log().warn("No stream returned for [%s]", resource.toString());
                byte[] byArray = SILENCE;
                return byArray;
            }
            if (stream.available() >= 65536) return null;
            int bytesRead = ByteStreams.read((InputStream)stream, (byte[])BUFFER, (int)0, (int)65536);
            if (bytesRead == 0 || bytesRead == 65536) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = Arrays.copyOf(BUFFER, bytesRead);
            return byArray;
        }
        catch (Throwable t) {
            LibLog.log().warn("Error reading stream [%s]", resource.toString());
            return SILENCE;
        }
    }

    private static URL load(@Nonnull ResourceLocation key) throws Exception {
        byte[] buffer = SoundCache.getBuffer(key);
        SoundStreamHandler handler = buffer == null ? new SoundStreamHandler(key) : new MemoryStreamHandler(key, buffer);
        return new URL((URL)null, handler.getSpec(), handler);
    }

    private SoundCache() {
    }

    public static URL getURLForSoundResource(@Nonnull ResourceLocation soundResource) {
        URL result = cache.get(soundResource);
        if (result == null) {
            try {
                result = SoundCache.load(soundResource);
                cache.put(soundResource, result);
            }
            catch (Throwable t) {
                LibLog.log().warn("Unable to load sound resource for [%s]", soundResource.toString());
                result = SILENCE_URL;
            }
        }
        return result;
    }

    static {
        try {
            MemoryStreamHandler handler = new MemoryStreamHandler(SILENCE_RESOURCE, SILENCE);
            SILENCE_URL = new URL((URL)null, handler.getSpec(), handler);
        }
        catch (Exception e) {
            e.printStackTrace();
            SILENCE_URL = null;
        }
    }
}

