/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.scanner;

import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import org.blockartistry.lib.BlockPosHelper;
import org.blockartistry.lib.scanner.Cuboid;
import org.blockartistry.lib.scanner.IPointIterator;

public class CuboidPointIterator
implements IPointIterator {
    static final CuboidPointIterator NULL_ITERATOR = new CuboidPointIterator(){

        @Override
        public BlockPos next() {
            return null;
        }

        @Override
        public BlockPos peek() {
            return null;
        }
    };
    protected final Iterator<BlockPos.MutableBlockPos> itr;
    protected BlockPos peeked;

    private CuboidPointIterator() {
        this.itr = null;
    }

    public CuboidPointIterator(@Nonnull Cuboid other) {
        this(other.minimum(), other.maximum());
    }

    public CuboidPointIterator(@Nonnull BlockPos[] points) {
        this(points[0], points[1]);
    }

    public CuboidPointIterator(@Nonnull BlockPos p1, @Nonnull BlockPos p2) {
        this.itr = BlockPosHelper.getAllInBoxMutable(p1, p2).iterator();
        if (this.itr.hasNext()) {
            this.peeked = (BlockPos)this.itr.next();
        }
    }

    @Override
    @Nullable
    public BlockPos next() {
        BlockPos result = this.peeked;
        this.peeked = this.itr.hasNext() ? (BlockPos)this.itr.next() : null;
        return result;
    }

    @Override
    @Nullable
    public BlockPos peek() {
        return this.peeked;
    }
}

