/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.gui;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class GuiUtils {
    private GuiUtils() {
    }

    public static void drawCenteredString(FontRenderer fontRendererIn, String text, int x, int y, int color) {
        fontRendererIn.func_175063_a(text, (float)(x - fontRendererIn.func_78256_a(text) / 2), (float)y, color);
    }

    public static void drawString(FontRenderer fontRendererIn, String text, int x, int y, int color) {
        fontRendererIn.func_175063_a(text, (float)x, (float)y, color);
    }

    public static void drawRect(int left, int top, int right, int bottom, int color) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float zLevel = 0.0f;
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer t = tessellator.func_178180_c();
        t.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        t.func_181662_b((double)(left + right), (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        t.func_181662_b((double)left, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        t.func_181662_b((double)left, (double)(top + bottom), 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        t.func_181662_b((double)(left + right), (double)(top + bottom), 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawTooltipBox(int x, int y, int w, int h, int bg, int grad1, int grad2) {
        GuiUtils.drawGradientRect(x + 1, y, w - 1, 1, bg, bg);
        GuiUtils.drawGradientRect(x + 1, y + h, w - 1, 1, bg, bg);
        GuiUtils.drawGradientRect(x, y + 1, 1, h - 1, bg, bg);
        GuiUtils.drawGradientRect(x + w, y + 1, 1, h - 1, bg, bg);
        GuiUtils.drawGradientRect(x + 1, y + 2, 1, h - 3, grad1, grad2);
        GuiUtils.drawGradientRect(x + w - 1, y + 2, 1, h - 3, grad1, grad2);
        GuiUtils.drawGradientRect(x + 1, y + 1, w - 1, 1, grad1, grad1);
        GuiUtils.drawGradientRect(x + 1, y + h - 1, w - 1, 1, grad2, grad2);
    }

    public static void drawTexturedModalRect(@Nonnull ResourceLocation texture, int x, int y, int width, int height, @Nonnull Vec2f u, @Nonnull Vec2f v) {
        float zLevel = 0.0f;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_187315_a((double)u.field_189982_i, (double)v.field_189982_i).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)u.field_189983_j, (double)v.field_189982_i).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_187315_a((double)u.field_189983_j, (double)v.field_189983_j).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_187315_a((double)u.field_189982_i, (double)v.field_189983_j).func_181675_d();
        tessellator.func_78381_a();
    }

    public static Vec2f calculateSpan(int sheetDimension, int first, int second) {
        return new Vec2f((float)first / (float)sheetDimension, (float)second / (float)sheetDimension);
    }
}

