/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.gfx;

import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import org.blockartistry.lib.gfx.OpenGlState;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public abstract class GeneratedTexture {
    protected final DynamicTexture texture;
    protected final ResourceLocation resource;
    protected final int width;
    protected final int height;
    protected final int size;

    public GeneratedTexture(String name, int width, int height) {
        this.width = width;
        this.height = height;
        this.size = width * height;
        this.texture = new DynamicTexture(this.width, this.height);
        this.resource = Minecraft.func_71410_x().func_110434_K().func_110578_a(name, this.texture);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getSize() {
        return this.texture.func_110565_c().length;
    }

    public void bindTexture() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.resource);
    }

    public void release() {
        this.texture.func_147631_c();
    }

    public boolean useDepth() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTexture() {
        Framebuffer mcFrameBuffer = Minecraft.func_71410_x().func_147110_a();
        Framebuffer blit = new Framebuffer(this.width, this.height, this.useDepth());
        blit.func_147614_f();
        blit.func_147610_a(this.useDepth());
        OpenGlState glState = OpenGlState.push();
        GL11.glPushAttrib((int)7072);
        GlStateManager.func_179094_E();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)this.getWidth(), (double)this.getHeight(), (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        GlStateManager.func_179098_w();
        try {
            this.render();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
        OpenGlState.pop(glState);
        try {
            blit.func_147612_c();
            IntBuffer pixelBuffer = BufferUtils.createIntBuffer((int)this.getSize());
            GlStateManager.func_187433_a((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)pixelBuffer);
            pixelBuffer.get(this.texture.func_110565_c(), 0, pixelBuffer.remaining());
            this.texture.func_110564_a();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            blit.func_147608_a();
            if (mcFrameBuffer != null) {
                mcFrameBuffer.func_147610_a(true);
            }
        }
    }

    public abstract void render();
}

