/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.expression;

import java.util.Iterator;
import java.util.Set;
import org.blockartistry.lib.expression.ExpressionException;

public final class Tokenizer
implements Iterator<String> {
    public static final char decimalSeparator = '.';
    public static final char minusSign = '-';
    public static final char quote = '\'';
    public static final char bang = '!';
    private int pos = 0;
    private final String input;
    private String previousToken;
    private final Set<String> operators;

    public Tokenizer(String input, Set<String> operators) {
        this.input = input.trim();
        this.operators = operators;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.input.length();
    }

    private char peekNextChar() {
        if (this.pos < this.input.length() - 1) {
            return this.input.charAt(this.pos + 1);
        }
        return '\u0000';
    }

    @Override
    public String next() {
        StringBuilder token = new StringBuilder();
        if (this.pos >= this.input.length()) {
            this.previousToken = null;
            return null;
        }
        char ch = this.input.charAt(this.pos);
        while (Character.isWhitespace(ch) && this.pos < this.input.length()) {
            ch = this.input.charAt(++this.pos);
        }
        if (Character.isDigit(ch)) {
            while ((Character.isDigit(ch) || ch == '.' || ch == 'e' || ch == 'E' || ch == '-' && token.length() > 0 && ('e' == token.charAt(token.length() - 1) || 'E' == token.charAt(token.length() - 1)) || ch == '+' && token.length() > 0 && ('e' == token.charAt(token.length() - 1) || 'E' == token.charAt(token.length() - 1))) && this.pos < this.input.length()) {
                token.append(this.input.charAt(this.pos++));
                ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
            }
        } else if (ch == '-' && Character.isDigit(this.peekNextChar()) && ("(".equals(this.previousToken) || ",".equals(this.previousToken) || this.previousToken == null || this.operators.contains(this.previousToken))) {
            token.append('-');
            ++this.pos;
            token.append(this.next());
        } else if (Character.isLetter(ch) || ch == '_') {
            while ((Character.isLetter(ch) || Character.isDigit(ch) || ch == '_' || ch == '.') && this.pos < this.input.length()) {
                token.append(this.input.charAt(this.pos++));
                ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
            }
        } else if (ch == '(' || ch == ')' || ch == ',') {
            token.append(ch);
            ++this.pos;
        } else if (ch == '\'') {
            token.append(ch);
            ++this.pos;
            char c = ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
            while (ch != '\'' && this.pos < this.input.length()) {
                token.append(this.input.charAt(this.pos++));
                ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
            }
            if (ch == '\u0000') {
                throw new ExpressionException("String not terminated '" + token + "'");
            }
            token.append(ch);
            ++this.pos;
        } else {
            while (!(Character.isLetter(ch) || Character.isDigit(ch) || ch == '_' || Character.isWhitespace(ch) || ch == '(' || ch == ')' || ch == ',' || ch == '\'' || this.pos >= this.input.length())) {
                token.append(this.input.charAt(this.pos));
                ++this.pos;
                char c = ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                if (ch != '-' && ch != '!') continue;
            }
            if (!this.operators.contains(token.toString())) {
                throw new ExpressionException("Unknown operator '" + token + "' at position " + (this.pos - token.length() + 1));
            }
        }
        this.previousToken = token.toString();
        return this.previousToken;
    }

    @Override
    public void remove() {
        throw new ExpressionException("remove() not supported");
    }

    public int getPos() {
        return this.pos;
    }
}

