/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.blockartistry.lib.expression.ExpressionException;
import org.blockartistry.lib.expression.FunctionTable;
import org.blockartistry.lib.expression.LazyFunction;
import org.blockartistry.lib.expression.LazyVariant;
import org.blockartistry.lib.expression.NumberValue;
import org.blockartistry.lib.expression.Operator;
import org.blockartistry.lib.expression.OperatorTable;
import org.blockartistry.lib.expression.StringValue;
import org.blockartistry.lib.expression.Tokenizer;
import org.blockartistry.lib.expression.VariableTable;
import org.blockartistry.lib.expression.Variant;

public final class Compiler {
    private static final LazyVariant PARAMS_START = () -> null;
    private final OperatorTable operators;
    private final FunctionTable functions;
    private final VariableTable variables;
    private LazyVariant exp;

    public Compiler(@Nullable OperatorTable operators, @Nullable FunctionTable functions, @Nullable VariableTable variables) {
        this.operators = operators != null ? operators : new OperatorTable();
        this.functions = functions != null ? functions : new FunctionTable();
        this.variables = variables != null ? variables : new VariableTable();
    }

    public Result compile(@Nonnull String expression) {
        Stack<LazyVariant> stack = new Stack<LazyVariant>();
        List<String> rpn = this.getRPN(expression);
        for (String token : rpn) {
            if (this.operators.containsKey(token)) {
                LazyVariant result;
                LazyVariant v1;
                Operator op = (Operator)this.operators.get(token);
                if (op.isUnary()) {
                    v1 = (LazyVariant)stack.pop();
                    result = () -> op.eval(v1);
                } else {
                    v1 = (LazyVariant)stack.pop();
                    LazyVariant v2 = (LazyVariant)stack.pop();
                    result = () -> op.eval(v2, v1);
                }
                stack.push(result);
                continue;
            }
            if (this.variables.containsKey(token)) {
                stack.push((LazyVariant)this.variables.get(token));
                continue;
            }
            if (this.functions.containsKey(token.toUpperCase(Locale.ROOT))) {
                LazyFunction f = (LazyFunction)this.functions.get(token.toUpperCase(Locale.ROOT));
                ArrayList p = new ArrayList(!f.numParamsVaries() ? f.getNumParams() : 0);
                while (!stack.isEmpty() && stack.peek() != PARAMS_START) {
                    p.add(0, stack.pop());
                }
                if (stack.peek() == PARAMS_START) {
                    stack.pop();
                }
                LazyVariant[] parms = new LazyVariant[p.size()];
                p.toArray(parms);
                LazyVariant fResult = () -> f.lazyEval(parms).eval();
                stack.push(fResult);
                continue;
            }
            if ("(".equals(token)) {
                stack.push(PARAMS_START);
                continue;
            }
            if (token.charAt(0) == '\'') {
                String s = token.substring(1, token.length() - 1);
                stack.push(new StringValue(s));
                continue;
            }
            float val = Float.parseFloat(token);
            stack.push(new NumberValue(val));
        }
        return new Result((LazyVariant)stack.pop(), rpn);
    }

    private static boolean isNumber(String st) {
        if (st.charAt(0) == '-' && st.length() == 1) {
            return false;
        }
        if (st.charAt(0) == '+' && st.length() == 1) {
            return false;
        }
        if (st.charAt(0) == 'e' || st.charAt(0) == 'E') {
            return false;
        }
        for (char ch : st.toCharArray()) {
            if (Character.isDigit(ch) || ch == '-' || ch == '.' || ch == 'e' || ch == 'E' || ch == '+') continue;
            return false;
        }
        return true;
    }

    private List<String> shuntingYard(String expression) {
        ArrayList<String> outputQueue = new ArrayList<String>();
        Stack<String> stack = new Stack<String>();
        Tokenizer tokenizer = new Tokenizer(expression, this.operators.keySet());
        String lastFunction = null;
        String previousToken = null;
        while (tokenizer.hasNext()) {
            String token = tokenizer.next();
            if (Compiler.isNumber(token)) {
                outputQueue.add(token);
            } else if (token.charAt(0) == '\'') {
                outputQueue.add(token);
            } else if (this.variables.containsKey(token)) {
                outputQueue.add(token);
            } else if (this.functions.containsKey(token.toUpperCase(Locale.ROOT))) {
                stack.push(token);
                lastFunction = token;
            } else if (Character.isLetter(token.charAt(0))) {
                stack.push(token);
            } else if (",".equals(token)) {
                if (this.operators.containsKey(previousToken)) {
                    throw new ExpressionException("Missing parameter(s) for operator " + previousToken + " at character position " + (tokenizer.getPos() - 1 - previousToken.length()));
                }
                while (!stack.isEmpty() && !"(".equals(stack.peek())) {
                    outputQueue.add((String)stack.pop());
                }
                if (stack.isEmpty()) {
                    throw new ExpressionException("Parse error for function '" + lastFunction + "'");
                }
            } else if (this.operators.containsKey(token)) {
                String token2;
                if (",".equals(previousToken) || "(".equals(previousToken)) {
                    throw new ExpressionException("Missing parameter(s) for operator " + token + " at character position " + (tokenizer.getPos() - token.length()));
                }
                Operator o1 = (Operator)this.operators.get(token);
                String string = token2 = stack.isEmpty() ? null : (String)stack.peek();
                while (token2 != null && this.operators.containsKey(token2) && (o1.isLeftAssoc() && o1.getPrecedence() <= ((Operator)this.operators.get(token2)).getPrecedence() || o1.getPrecedence() < ((Operator)this.operators.get(token2)).getPrecedence())) {
                    outputQueue.add((String)stack.pop());
                    token2 = stack.isEmpty() ? null : (String)stack.peek();
                }
                stack.push(token);
            } else if ("(".equals(token)) {
                if (previousToken != null) {
                    if (Compiler.isNumber(previousToken)) {
                        throw new ExpressionException("Missing operator at character position " + tokenizer.getPos());
                    }
                    if (this.functions.containsKey(previousToken.toUpperCase(Locale.ROOT))) {
                        outputQueue.add(token);
                    }
                }
                stack.push(token);
            } else if (")".equals(token)) {
                if (this.operators.containsKey(previousToken)) {
                    throw new ExpressionException("Missing parameter(s) for operator " + previousToken + " at character position " + (tokenizer.getPos() - 1 - previousToken.length()));
                }
                while (!stack.isEmpty() && !"(".equals(stack.peek())) {
                    outputQueue.add((String)stack.pop());
                }
                if (stack.isEmpty()) {
                    throw new ExpressionException("Mismatched parentheses");
                }
                stack.pop();
                if (!stack.isEmpty() && this.functions.containsKey(((String)stack.peek()).toUpperCase(Locale.ROOT))) {
                    outputQueue.add((String)stack.pop());
                }
            }
            previousToken = token;
        }
        while (!stack.isEmpty()) {
            String element = (String)stack.pop();
            if ("(".equals(element) || ")".equals(element)) {
                throw new ExpressionException("Mismatched parentheses");
            }
            if (!this.operators.containsKey(element)) {
                throw new ExpressionException("Unknown operator or function: " + element);
            }
            outputQueue.add(element);
        }
        return outputQueue;
    }

    public Variant eval() {
        if (this.exp == null) {
            // empty if block
        }
        return this.exp.eval();
    }

    private List<String> getRPN(@Nonnull String expression) {
        List<String> rpn = this.shuntingYard(expression);
        this.validate(rpn);
        return rpn;
    }

    private void validate(List<String> rpn) {
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(0);
        for (String token : rpn) {
            if (this.operators.containsKey(token)) {
                if (((Operator)this.operators.get(token)).isUnary()) {
                    if ((Integer)stack.peek() < 1) {
                        throw new ExpressionException("Missing parameter(s) for operator " + token);
                    }
                    stack.set(stack.size() - 1, (Integer)stack.peek() - 1 + 1);
                    continue;
                }
                if ((Integer)stack.peek() < 2) {
                    throw new ExpressionException("Missing parameter(s) for operator " + token);
                }
                stack.set(stack.size() - 1, (Integer)stack.peek() - 2 + 1);
                continue;
            }
            if (this.variables.containsKey(token)) {
                stack.set(stack.size() - 1, (Integer)stack.peek() + 1);
                continue;
            }
            if (this.functions.containsKey(token.toUpperCase(Locale.ROOT))) {
                LazyFunction f = (LazyFunction)this.functions.get(token.toUpperCase(Locale.ROOT));
                int numParams = (Integer)stack.pop();
                if (!f.numParamsVaries() && numParams != f.getNumParams()) {
                    throw new ExpressionException("Function " + token + " expected " + f.getNumParams() + " parameters, got " + numParams);
                }
                if (stack.size() <= 0) {
                    throw new ExpressionException("Too many function calls, maximum scope exceeded");
                }
                stack.set(stack.size() - 1, (Integer)stack.peek() + 1);
                continue;
            }
            if ("(".equals(token)) {
                stack.push(0);
                continue;
            }
            stack.set(stack.size() - 1, (Integer)stack.peek() + 1);
        }
        if (stack.size() > 1) {
            throw new ExpressionException("Too many unhandled function parameter lists");
        }
        if ((Integer)stack.peek() > 1) {
            throw new ExpressionException("Too many numbers or variables");
        }
        if ((Integer)stack.peek() < 1) {
            throw new ExpressionException("Empty expression");
        }
    }

    public static class Result {
        public final LazyVariant expression;
        public final List<String> rpn;

        Result(@Nonnull LazyVariant exp, @Nonnull List<String> rpn) {
            this.expression = exp;
            this.rpn = rpn;
        }
    }
}

