/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.effects;

import java.lang.ref.WeakReference;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.lib.effects.EffectStateBase;
import org.blockartistry.lib.effects.IEntityEffectState;
import org.blockartistry.lib.effects.IParticleHelper;
import org.blockartistry.lib.effects.ISoundHelper;

@SideOnly(value=Side.CLIENT)
public class EntityEffectStateBase
extends EffectStateBase
implements IEntityEffectState {
    protected final WeakReference<Entity> subject;

    public EntityEffectStateBase(@Nonnull Entity entity, @Nonnull IParticleHelper ph, @Nonnull ISoundHelper sh) {
        super(ph, sh);
        this.subject = new WeakReference<Entity>(entity);
    }

    @Override
    @Nonnull
    public Optional<Entity> subject() {
        return Optional.ofNullable(this.subject.get());
    }

    @Override
    public boolean isSubjectAlive() {
        Entity e = (Entity)this.subject.get();
        return e != null && e.func_70089_S();
    }

    @Override
    public double distanceSq(Entity entity) {
        Entity e = (Entity)this.subject.get();
        if (e == null) {
            return Double.MAX_VALUE;
        }
        return e.func_70068_e(entity);
    }

    @Override
    public long getWorldTime() {
        Entity e = (Entity)this.subject.get();
        return e == null ? 0L : e.func_130014_f_().func_82737_E();
    }
}

