/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.effects;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.lib.effects.EntityEffect;
import org.blockartistry.lib.effects.EntityEffectStateBase;
import org.blockartistry.lib.effects.IEntityEffectHandlerState;
import org.blockartistry.lib.effects.IParticleHelper;
import org.blockartistry.lib.effects.ISoundHelper;

@SideOnly(value=Side.CLIENT)
public class EntityEffectHandler
extends EntityEffectStateBase
implements IEntityEffectHandlerState {
    protected final List<EntityEffect> activeEffects;
    protected boolean isAlive = true;
    protected double rangeToPlayer;

    public EntityEffectHandler(@Nonnull Entity entity, @Nonnull IParticleHelper ph, @Nonnull ISoundHelper sh) {
        super(entity, ph, sh);
        this.activeEffects = null;
    }

    public EntityEffectHandler(@Nonnull Entity entity, @Nonnull List<EntityEffect> effects2, @Nonnull IParticleHelper ph, @Nonnull ISoundHelper sh) {
        super(entity, ph, sh);
        this.activeEffects = effects2;
        for (EntityEffect ee : this.activeEffects) {
            ee.intitialize(this);
        }
    }

    public void update() {
        if (!this.isAlive()) {
            return;
        }
        this.isAlive = this.isSubjectAlive();
        Entity entity = (Entity)this.subject.get();
        if (entity != null) {
            EntityPlayerSP player2 = Minecraft.func_71410_x().field_71439_g;
            this.rangeToPlayer = entity.func_70068_e((Entity)player2);
            for (EntityEffect e : this.activeEffects) {
                if (!this.isAlive && !e.receiveLastCall()) continue;
                e.update(entity);
            }
        }
    }

    public void die() {
        this.isAlive = false;
        for (EntityEffect e : this.activeEffects) {
            e.die();
        }
    }

    public boolean isDummy() {
        return false;
    }

    @Nonnull
    public List<String> getAttachedEffects() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.activeEffects.size() == 0) {
            result.add("No effects");
        } else {
            for (EntityEffect e : this.activeEffects) {
                result.add(e.toString());
            }
        }
        return result;
    }

    @Override
    public boolean isAlive() {
        return this.isAlive;
    }

    @Override
    public double rangeToPlayerSq() {
        return this.rangeToPlayer;
    }

    public static class Dummy
    extends EntityEffectHandler {
        public Dummy(@Nonnull Entity entity) {
            super(entity, null, null);
        }

        @Override
        public void update() {
        }

        @Override
        public void die() {
            this.isAlive = false;
        }

        @Override
        public boolean isDummy() {
            return true;
        }

        @Override
        public List<String> getAttachedEffects() {
            return ImmutableList.of((Object)"Dummy EffectHandler");
        }
    }
}

