/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.effects;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.sound.BasicSound;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.lib.effects.IEffectState;
import org.blockartistry.lib.effects.IParticleHelper;
import org.blockartistry.lib.effects.ISoundHelper;
import org.blockartistry.lib.sound.ITrackedSound;

@SideOnly(value=Side.CLIENT)
public class EffectStateBase
implements IEffectState {
    protected final IParticleHelper particleHelper;
    protected final ISoundHelper soundHelper;

    public EffectStateBase(@Nonnull IParticleHelper ph, @Nonnull ISoundHelper sh) {
        this.particleHelper = ph;
        this.soundHelper = sh;
    }

    @Override
    public void addParticle(Particle particle) {
        this.particleHelper.addParticle(particle);
    }

    @Override
    @Nullable
    public String playSound(@Nonnull ITrackedSound sound2) {
        return this.soundHelper.playSound(sound2);
    }

    @Override
    public void stopSound(@Nonnull ITrackedSound sound2) {
        this.soundHelper.stopSound(sound2);
    }

    @Override
    @Nonnull
    public BasicSound<?> createSound(@Nonnull SoundEffect se, @Nonnull Entity player2) {
        return se.createTrackingSound(player2, false);
    }

    @Override
    public boolean isActivePlayer(@Nonnull Entity player2) {
        EntityPlayerSP ep = Minecraft.func_71410_x().field_71439_g;
        return ep != null && ep.func_145782_y() == player2.func_145782_y();
    }

    @Override
    @Nonnull
    public EntityPlayer thePlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }
}

