/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib.chunk;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import org.blockartistry.lib.chunk.IBlockAccessEx;
import org.blockartistry.lib.chunk.IChunkCache;

public class PassThroughChunkCache
implements IChunkCache,
IBlockAccessEx {
    protected final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    protected int minCX;
    protected int minCZ;
    protected int maxCX;
    protected int maxCZ;
    protected World world;
    protected int worldRef;
    protected int ref;
    protected ChunkCache cache;
    protected boolean anyEmpty = true;

    @Override
    public void update(@Nonnull World world, @Nonnull BlockPos min, @Nonnull BlockPos max) {
        ChunkPos from = new ChunkPos(min);
        ChunkPos to = new ChunkPos(max);
        if (this.anyEmpty || this.world != world || from.field_77276_a < this.minCX || from.field_77275_b < this.minCZ || to.field_77276_a > this.maxCX || to.field_77275_b > this.maxCZ) {
            if (this.world != world) {
                ++this.worldRef;
            }
            ++this.ref;
            this.world = world;
            this.minCX = from.field_77276_a;
            this.minCZ = from.field_77275_b;
            this.maxCX = to.field_77276_a;
            this.maxCZ = to.field_77275_b;
            this.cache = new ChunkCache(world, min, max, 0);
            this.anyEmpty = false;
            block0: for (int cX = this.minCX; cX <= this.maxCX; ++cX) {
                for (int cZ = this.minCZ; cZ <= this.maxCZ; ++cZ) {
                    if (this.world.func_72863_F().func_186026_b(cX, cZ) != null) continue;
                    this.anyEmpty = true;
                    continue block0;
                }
            }
        }
    }

    @Override
    public void clear() {
        this.cache = null;
        this.world = null;
    }

    public TileEntity func_175625_s(@Nonnull BlockPos pos) {
        return this.cache == null ? null : this.cache.func_175625_s(pos);
    }

    public int func_175626_b(@Nonnull BlockPos pos, int lightValue) {
        return this.cache == null ? lightValue : this.cache.func_175626_b(pos, lightValue);
    }

    public IBlockState func_180495_p(@Nonnull BlockPos pos) {
        return this.cache == null ? Blocks.field_150350_a.func_176223_P() : this.cache.func_180495_p(pos);
    }

    public boolean func_175623_d(@Nonnull BlockPos pos) {
        return this.cache != null && this.cache.func_175623_d(pos);
    }

    public Biome func_180494_b(@Nonnull BlockPos pos) {
        if (this.cache != null) {
            try {
                return this.cache.func_180494_b(pos);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Biomes.field_76772_c;
    }

    public int func_175627_a(@Nonnull BlockPos pos, @Nonnull EnumFacing direction) {
        return this.cache == null ? 0 : this.cache.func_175627_a(pos, direction);
    }

    public WorldType func_175624_G() {
        return this.cache == null ? WorldType.field_77137_b : this.cache.func_175624_G();
    }

    public boolean isSideSolid(@Nonnull BlockPos pos, @Nonnull EnumFacing side, boolean _default) {
        return this.cache != null && this.cache.isSideSolid(pos, side, _default);
    }

    @Override
    public int reference() {
        return this.ref;
    }

    @Override
    public int worldReference() {
        return this.worldRef;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public IBlockState getBlockState(int x, int y, int z) {
        return this.cache == null ? Blocks.field_150350_a.func_176223_P() : this.cache.func_180495_p((BlockPos)this.pos.func_181079_c(x, y, z));
    }

    @Override
    public int getLightFor(@Nonnull EnumSkyBlock type, @Nonnull BlockPos pos) {
        return this.cache == null ? 0 : this.cache.func_175628_b(type, pos);
    }

    @Override
    public BlockPos getTopSolidOrLiquidBlock(@Nonnull BlockPos pos) {
        return this.world == null ? pos : this.world.func_175672_r(pos);
    }

    @Override
    public boolean isAvailable(int x, int z) {
        return this.world != null && this.world.func_72863_F().func_186026_b(x >> 4, z >> 4) != null;
    }

    @Override
    public BlockPos getPrecipitationHeight(@Nonnull BlockPos pos) {
        return this.world == null ? pos : this.world.func_175725_q(pos);
    }
}

