/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.ClientChunkCache;
import org.blockartistry.lib.chunk.IBlockAccessEx;

@SideOnly(value=Side.CLIENT)
public final class WorldUtils {
    private WorldUtils() {
    }

    @Nonnull
    public static IBlockAccessEx getDefaultBlockStateProvider() {
        return ClientChunkCache.INSTANCE;
    }

    @Nullable
    public static Entity locateEntity(@Nonnull World world, int entityId) {
        Entity entity = null;
        if (world != null) {
            try {
                entity = world.func_73045_a(entityId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return entity;
    }

    public static boolean isSolidBlock(@Nonnull World world, @Nonnull BlockPos pos) {
        return WorldUtils.getBlockState(world, pos).func_185904_a().func_76220_a();
    }

    public static boolean isAirBlock(@Nonnull IBlockState state) {
        return state.func_177230_c() == Blocks.field_150350_a;
    }

    public static boolean isLeaves(@Nonnull IBlockState state) {
        return state.func_185904_a() == Material.field_151584_j;
    }

    public static boolean isAirBlock(@Nonnull World world, @Nonnull BlockPos pos) {
        return WorldUtils.isAirBlock(WorldUtils.getBlockState(world, pos));
    }

    @Nonnull
    public static IBlockState getBlockState(@Nonnull World world, @Nonnull BlockPos pos) {
        return WorldUtils.getDefaultBlockStateProvider().func_180495_p(pos);
    }

    @Nonnull
    public static IBlockState getBlockState(@Nonnull World world, int x, int y, int z) {
        return WorldUtils.getDefaultBlockStateProvider().getBlockState(x, y, z);
    }

    public static boolean isFullWaterBlock(@Nonnull World world, @Nonnull BlockPos pos) {
        return WorldUtils.isFullWaterBlock(WorldUtils.getDefaultBlockStateProvider().func_180495_p(pos));
    }

    public static boolean isFullWaterBlock(@Nonnull IBlockState state) {
        return state.func_185904_a() == Material.field_151586_h && state.func_177230_c().func_176223_P() == state;
    }

    public static boolean hasVoidPartiles(@Nonnull World world) {
        return world.func_175624_G() != WorldType.field_77138_c && !world.field_73011_w.func_177495_o();
    }
}

