/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib;

import javax.annotation.Nonnull;
import net.minecraftforge.fml.relauncher.Side;
import org.blockartistry.lib.logging.ModLog;

public final class ThreadGuard {
    public static final String CLIENT_THREAD = "Client thread";
    public static final String SERVER_THREAD = "Server thread";
    private final String threadName;
    private final String context;
    private final ModLog log;
    private Action action = Action.LOG;

    public ThreadGuard(@Nonnull ModLog log, @Nonnull Side side, @Nonnull String context) {
        this(log, side == Side.CLIENT ? CLIENT_THREAD : SERVER_THREAD, context);
    }

    public ThreadGuard(@Nonnull ModLog log, @Nonnull String threadName, @Nonnull String context) {
        this.log = log;
        this.threadName = threadName;
        this.context = context;
    }

    public ThreadGuard setAction(@Nonnull Action action) {
        this.action = action;
        return this;
    }

    public void check(@Nonnull String locus) {
        if (this.action == Action.NONE) {
            return;
        }
        String name = Thread.currentThread().getName();
        if (!name.equals(this.threadName)) {
            String txt = String.format("[%s::%s] illegal access by thread [%s]!", this.context, locus, name);
            if (this.action == Action.LOG) {
                this.log.error(txt, new Throwable());
            } else {
                throw new RuntimeException(txt);
            }
        }
    }

    public static enum Action {
        NONE,
        LOG,
        EXCEPTION;

    }
}

