/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.lib.LibLog;

public final class BlockNameUtil {
    private static final int GENERIC = -1;
    private static final int META_NOT_SPECIFIED = -100;
    private static final char NO_CONTROL_CODE = '\u0000';
    private static final Pattern pattern = Pattern.compile("(\\W)?([\\w\\-]+:[\\w\\.\\-/]+)[\\^|:]?(\\d+|\\*)?\\+?(\\w+)?");

    private BlockNameUtil() {
    }

    @Nullable
    public static NameResult parseBlockName(@Nonnull String blockName) {
        try {
            Matcher matcher = pattern.matcher(blockName);
            return matcher.matches() ? new NameResult(matcher) : null;
        }
        catch (Exception ex) {
            LibLog.log().error(String.format("Unable to parse '%s'", blockName), ex);
            return null;
        }
    }

    public static final class NameResult {
        private final char control;
        private final String block;
        private final int metaData;
        private final String extras;

        NameResult(Matcher matcher) {
            String temp = matcher.group(1);
            this.control = !StringUtils.isEmpty((CharSequence)temp) ? temp.charAt(0) : (char)'\u0000';
            this.block = matcher.group(2);
            temp = matcher.group(3);
            if (StringUtils.isEmpty((CharSequence)temp)) {
                this.metaData = -100;
            } else if ("*".equals(temp)) {
                this.metaData = -1;
            } else {
                this.metaData = Integer.parseInt(temp);
                if (this.metaData < 0 || this.metaData > 15) {
                    LibLog.log().warn("Metadata is not in the normal range: %d", this.metaData);
                }
            }
            this.extras = matcher.group(4);
        }

        public boolean hasControlCode() {
            return this.control != '\u0000';
        }

        public boolean isGeneric() {
            return this.metaData == -1;
        }

        public boolean noMetadataSpecified() {
            return this.metaData == -100;
        }

        public boolean hasExtras() {
            return !StringUtils.isEmpty((CharSequence)this.extras);
        }

        public char getControlCode() {
            return this.control;
        }

        @Nonnull
        public String getBlockName() {
            return this.block;
        }

        public int getMetadata() {
            return this.metaData;
        }

        @Nullable
        public String getExtras() {
            return this.extras;
        }

        @Nonnull
        public String toString() {
            String t = this.metaData == -1 ? "GENERIC" : (this.metaData == -100 ? "META_NOT_SPECIFIED" : Integer.toString(this.metaData));
            return String.format("['%c', %s, %s, '%s']", Character.valueOf(this.control), this.block, t, this.extras);
        }
    }
}

