/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.blockartistry.lib.Color;
import org.blockartistry.lib.WorldUtils;
import org.blockartistry.lib.collections.IdentityHashSet;

public final class BiomeUtils {
    private static final Color NO_COLOR = new Color.ImmutableColor(1.0f, 1.0f, 1.0f);

    private BiomeUtils() {
    }

    public static Set<BiomeDictionary.Type> getBiomeTypes() {
        return new IdentityHashSet<BiomeDictionary.Type>(BiomeDictionary.Type.values());
    }

    @Nonnull
    public static Color getBiomeWaterColor(@Nonnull World world, @Nonnull BlockPos pos) {
        return new Color(BiomeColorHelper.func_180288_c((IBlockAccess)world, (BlockPos)pos));
    }

    @Nullable
    public static Color getColorForLiquid(@Nonnull World world, @Nonnull BlockPos pos) {
        return BiomeUtils.getColorForLiquid(world, WorldUtils.getBlockState(world, pos), pos);
    }

    @Nonnull
    public static Color getColorForLiquid(@Nonnull World world, @Nonnull IBlockState state, @Nonnull BlockPos pos) {
        Block liquid = state.func_177230_c();
        if (liquid == Blocks.field_150355_j) {
            return BiomeUtils.getBiomeWaterColor(world, pos);
        }
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)liquid);
        if (fluid != null) {
            return new Color(fluid.getColor());
        }
        return NO_COLOR;
    }

    @Nonnull
    public static Set<BiomeDictionary.Type> getBiomeTypes(@Nonnull Biome biome) {
        return new IdentityHashSet<BiomeDictionary.Type>(BiomeDictionary.getTypesForBiome((Biome)biome));
    }

    public static boolean areBiomesSimilar(@Nonnull Biome b1, @Nonnull Biome b2) {
        return BiomeDictionary.areBiomesEquivalent((Biome)b1, (Biome)b2);
    }
}

