/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.Presets.proxy;

import java.io.File;
import java.io.InputStream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.Presets.Presets;
import org.blockartistry.Presets.handler.MinecraftConfigHandler;
import org.blockartistry.Presets.keyboard.KeyHandler;
import org.blockartistry.Presets.proxy.Proxy;
import org.blockartistry.lib.Localization;
import org.blockartistry.lib.io.Streams;

@SideOnly(value=Side.CLIENT)
public class ProxyClient
extends Proxy {
    private static final String[] presetFiles = new String[]{"presets_level0", "presets_level1", "presets_level2", "presets_level3", "dsurround_skyblock", "dsurround_emojis", "dsurround_turnalloff", "dsurround_ponies"};

    @Override
    protected void registerLanguage() {
        Localization.initialize(Side.CLIENT);
    }

    @Override
    protected void eventBusRegistrations() {
        ProxyClient.register(MinecraftConfigHandler.class);
        ProxyClient.register(KeyHandler.class);
    }

    @Override
    public boolean isRunningAsServer() {
        return false;
    }

    @Override
    public Side effectiveSide() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    @Override
    public void preInit(@Nonnull FMLPreInitializationEvent event) {
        super.preInit(event);
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        for (String preset : presetFiles) {
            String name = preset + ".presets";
            try {
                IResource r = manager.func_110536_a(new ResourceLocation("presets", "data/" + name));
                try (InputStream stream = r.func_110527_b();){
                    Streams.copy(stream, new File(Presets.dataDirectory(), name));
                }
            }
            catch (Throwable t) {
                Presets.log().error("Unable to extract preset file " + name, t);
            }
        }
    }

    @Override
    public void init(@Nonnull FMLInitializationEvent event) {
        super.init(event);
        KeyHandler.init();
    }
}

