/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.Presets.gui;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.Presets.data.PresetInfo;
import org.blockartistry.Presets.gui.PresetsConfigGui;
import org.blockartistry.lib.Color;
import org.blockartistry.lib.Localization;
import org.blockartistry.lib.gui.Panel;
import org.blockartistry.lib.gui.StandardPanel;

@SideOnly(value=Side.CLIENT)
public class PresetInfoModifyGui
extends GuiScreen {
    protected static final String CREATE_TITLE = Localization.format("presets.dlg.CreateTitle", new Object[0]);
    protected static final String EDIT_TITLE = Localization.format("presets.dlg.EditTitle", new Object[0]);
    protected static final String FILENAME_LABEL = Localization.format("presets.dlg.FileName", new Object[0]);
    protected static final String PRESET_TITLE_LABEL = Localization.format("presets.dlg.Title", new Object[0]);
    protected static final String PRESET_DESCRIPTION_LABEL = Localization.format("presets.dlg.Description", new Object[0]);
    protected static final String DONE_BUTTON_LABEL = Localization.format("presets.button.Done", new Object[0]);
    protected static final String CANCEL_BUTTON_LABEL = Localization.format("presets.button.Cancel", new Object[0]);
    protected static final String REQUIRED_TEXT = Localization.format("presets.dlg.Required", new Object[0]);
    protected static final String FILENAME_VALIDATION_REGEX = ".*[^\\w -.].*";
    protected static final int ID_TITLE = 500;
    protected static final int ID_PRESET_FILENAME = 501;
    protected static final int ID_PRESET_TITLE = 502;
    protected static final int ID_PRESET_DESCRIPTION = 503;
    protected static final int ID_FILENAME_REQUIRED = 504;
    protected static final int ID_TITLE_REQUIRED = 505;
    protected static final int ID_PRESET_FILENAME_TEXT = 700;
    protected static final int ID_PRESET_TITLE_TEXT = 701;
    protected static final int ID_PRESET_DESCRIPTION_TEXT = 703;
    protected static final int ID_DONE = 1000;
    protected static final int ID_CANCEL = 1001;
    protected static final int REGION_WIDTH = 335;
    protected static final int REGION_HEIGHT = 200;
    protected static final int MARGIN = 10;
    protected static final int INSET = 5;
    protected static final int BUTTON_WIDTH = 100;
    protected static final int BUTTON_HEIGHT = 20;
    protected static final int LABEL_WIDTH = 300;
    protected final PresetsConfigGui parentScreen;
    protected int anchorX;
    protected int anchorY;
    protected int regionWidth;
    protected int regionHeight;
    protected GuiTextField fileName;
    protected GuiTextField presetTitle;
    protected GuiTextField presetDescription;
    protected GuiButtonExt doneButton;
    protected GuiLabel fileNameRequired;
    protected GuiLabel presetTitleRequired;
    protected final StandardPanel backgroundPanel = new StandardPanel();
    protected final int buttonId;
    protected final boolean editMode;
    protected final PresetInfo info;

    public PresetInfoModifyGui(@Nonnull PresetsConfigGui parent, PresetInfo info, boolean editMode, int buttonId) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.parentScreen = parent;
        this.buttonId = buttonId;
        this.editMode = editMode;
        this.info = info;
    }

    public void func_73866_w_() {
        this.field_146293_o.clear();
        this.field_146292_n.clear();
        this.anchorX = (this.field_146294_l - 335) / 2;
        this.anchorY = (this.field_146295_m - 200) / 2;
        String theTitle = this.editMode ? EDIT_TITLE : CREATE_TITLE;
        int titleWidth = this.field_146289_q.func_78256_a(theTitle);
        int X = this.anchorX + (335 - titleWidth) / 2;
        int Y = this.anchorY + 10;
        GuiLabel label = new GuiLabel(this.field_146289_q, 500, X, Y, 335, 20, Color.MC_GOLD.rgb());
        label.func_175202_a(theTitle);
        this.field_146293_o.add(label);
        X = this.anchorX + 10;
        int entryWidth = 315;
        int labelColor = Color.WHITE.rgb();
        int requiredWidth = this.field_146289_q.func_78256_a(REQUIRED_TEXT);
        label = new GuiLabel(this.field_146289_q, 501, X, Y += 20, 300, 20, labelColor);
        label.func_175202_a(FILENAME_LABEL);
        this.field_146293_o.add(label);
        this.fileNameRequired = new GuiLabel(this.field_146289_q, 504, X + 315 - requiredWidth, Y, 300, 20, Color.RED.rgb());
        this.fileNameRequired.func_175202_a(REQUIRED_TEXT);
        this.fileNameRequired.field_146172_j = false;
        this.field_146293_o.add(this.fileNameRequired);
        this.fileName = new GuiTextField(700, this.field_146289_q, X, Y += 20, 315, 20);
        this.fileName.func_146203_f(32);
        this.fileName.func_146180_a(this.info.getFilename());
        this.fileName.func_175205_a(input -> !input.matches(FILENAME_VALIDATION_REGEX));
        label = new GuiLabel(this.field_146289_q, 501, X, Y += 25, 300, 20, labelColor);
        label.func_175202_a(PRESET_TITLE_LABEL);
        this.field_146293_o.add(label);
        this.presetTitleRequired = new GuiLabel(this.field_146289_q, 505, X + 315 - requiredWidth, Y, 300, 20, Color.RED.rgb());
        this.presetTitleRequired.func_175202_a(REQUIRED_TEXT);
        this.presetTitleRequired.field_146172_j = false;
        this.field_146293_o.add(this.presetTitleRequired);
        this.presetTitle = new GuiTextField(701, this.field_146289_q, X, Y += 20, 315, 20);
        this.presetTitle.func_146203_f(48);
        this.presetTitle.func_146180_a(this.info.getTitle());
        label = new GuiLabel(this.field_146289_q, 501, X, Y += 25, 300, 20, labelColor);
        label.func_175202_a(PRESET_DESCRIPTION_LABEL);
        this.field_146293_o.add(label);
        this.presetDescription = new GuiTextField(703, this.field_146289_q, X, Y += 20, 315, 20);
        this.presetDescription.func_146203_f(255);
        this.presetDescription.func_146180_a(this.info.getDescription());
        this.regionWidth = 335;
        this.regionHeight = (Y += 60) - this.anchorY;
        this.backgroundPanel.setWidth(this.regionWidth);
        this.backgroundPanel.setHeight(this.regionHeight);
        int doneX = this.anchorX + (this.regionWidth - 300) / 2;
        int doneY = this.anchorY + this.regionHeight - 30;
        this.doneButton = new GuiButtonExt(1000, doneX, doneY, 100, 20, DONE_BUTTON_LABEL);
        this.field_146292_n.add(this.doneButton);
        GuiButtonExt button = new GuiButtonExt(1001, doneX += 200, doneY, 100, 20, CANCEL_BUTTON_LABEL);
        this.field_146292_n.add(button);
        this.fileName.func_146195_b(true);
        this.doneEnableCheck();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.backgroundPanel.render(this.anchorX, this.anchorY, Panel.Reference.UPPER_LEFT);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.fileName.func_146194_f();
        this.presetTitle.func_146194_f();
        this.presetDescription.func_146194_f();
    }

    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 1000: {
                this.info.setDescription(this.presetDescription.func_146179_b().trim());
                this.info.setTitle(this.presetTitle.func_146179_b().trim());
                this.info.setFilename(this.fileName.func_146179_b());
                this.parentScreen.confirmUpdate(true, this.buttonId, this.info);
                break;
            }
            case 1001: {
                this.parentScreen.confirmUpdate(false, this.buttonId, this.info);
                break;
            }
            default: {
                super.func_146284_a(button);
            }
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.fileName.func_146192_a(mouseX, mouseY, mouseButton);
        this.presetTitle.func_146192_a(mouseX, mouseY, mouseButton);
        this.presetDescription.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void doneEnableCheck() {
        boolean fName = this.fileName.func_146179_b().trim().length() > 0;
        boolean pTitle = this.presetTitle.func_146179_b().trim().length() > 0;
        this.fileNameRequired.field_146172_j = !fName;
        this.presetTitleRequired.field_146172_j = !pTitle;
        this.doneButton.field_146124_l = fName && pTitle;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.fileName.func_146206_l()) {
            this.fileName.func_146201_a(typedChar, keyCode);
        } else if (this.presetTitle.func_146206_l()) {
            this.presetTitle.func_146201_a(typedChar, keyCode);
        } else if (this.presetDescription.func_146206_l()) {
            this.presetDescription.func_146201_a(typedChar, keyCode);
        }
        this.doneEnableCheck();
    }
}

