/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.Presets.data;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import org.blockartistry.Presets.api.PresetData;
import org.blockartistry.Presets.data.PresetDataFile;

public class PresetInfo
implements Comparable<PresetInfo> {
    protected String fileName = "";
    protected String title = "";
    protected String description = "";
    protected boolean restartRequired = false;
    protected Map<String, PresetData> data = Maps.newHashMap();

    public PresetInfo() {
    }

    public PresetInfo(@Nonnull PresetInfo src) {
        this.title = src.title;
        this.description = src.description;
        this.fileName = src.fileName;
        this.data = src.data;
    }

    public PresetInfo(@Nonnull String fileName) {
        this.fileName = fileName;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFilename() {
        return this.fileName;
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    public PresetInfo setTitle(@Nonnull String title) {
        this.title = title;
        return this;
    }

    public PresetInfo setDescription(@Nonnull String description) {
        this.description = description;
        return this;
    }

    public PresetInfo setFilename(@Nonnull String fileName) {
        this.fileName = fileName;
        return this;
    }

    public PresetInfo setRestartRequired(boolean flag) {
        this.restartRequired = flag;
        return this;
    }

    @Override
    public int compareTo(@Nonnull PresetInfo o) {
        return this.title.compareTo(o.title);
    }

    PresetInfo set0(@Nonnull Map<String, Map<String, String>> data) {
        this.data = Maps.newHashMap();
        for (Map.Entry<String, Map<String, String>> d : data.entrySet()) {
            this.data.put(d.getKey(), new PresetData(d.getValue()));
        }
        return this;
    }

    PresetInfo set1(@Nonnull Map<String, PresetData> data) {
        this.data = data;
        this.restartRequired = false;
        for (PresetData d : this.data.values()) {
            if (!d.isRestartRequired()) continue;
            this.restartRequired = true;
            break;
        }
        return this;
    }

    PresetInfo set(@Nonnull PresetDataFile data) {
        this.setTitle(data.title);
        this.setDescription(data.description);
        this.set0(data.data);
        this.setRestartRequired(data.restartRequired);
        return this;
    }

    Map<String, PresetData> getData() {
        return this.data;
    }
}

