/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.Presets.data;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.blockartistry.Presets.Presets;
import org.blockartistry.Presets.api.events.PresetEvent;
import org.blockartistry.Presets.data.PresetDataFile;
import org.blockartistry.Presets.data.PresetInfo;

public class PresetConfig {
    protected static final String PRESET_EXT = ".presets";
    protected static final FilenameFilter FILTER = (dir, name) -> name.endsWith(PRESET_EXT);
    protected final File dir;
    protected final List<PresetInfo> presets = Lists.newArrayList();
    protected boolean hasScanned = false;

    public PresetConfig(@Nonnull File directory) {
        this.dir = directory;
    }

    @Nonnull
    public List<PresetInfo> getPresets() {
        if (!this.hasScanned) {
            this.scan();
        }
        return ImmutableList.copyOf(this.presets);
    }

    public void scan() {
        this.presets.clear();
        for (File f : this.dir.listFiles(FILTER)) {
            PresetInfo info = this.load0(f);
            if (info == null) continue;
            this.presets.add(info);
        }
        Collections.sort(this.presets);
        this.hasScanned = true;
    }

    public void applyPreset(@Nonnull PresetInfo info) {
        PresetEvent.Load event = new PresetEvent.Load(info.getData());
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public PresetInfo collectPreset(@Nonnull PresetInfo info) {
        PresetEvent.Save event = new PresetEvent.Save();
        MinecraftForge.EVENT_BUS.post((Event)event);
        info.set1(event.getData());
        return info;
    }

    public void save(@Nonnull PresetInfo info) {
        if (!info.getFilename().endsWith(PRESET_EXT)) {
            info.setFilename(info.getFilename() + PRESET_EXT);
        }
        this.save0(info);
        Optional existing = Iterators.tryFind(this.presets.iterator(), input -> input.getFilename().equals(info.getFilename()));
        if (existing.isPresent()) {
            this.presets.remove(existing.get());
        }
        this.presets.add(info);
    }

    public void delete(@Nonnull PresetInfo info) {
        File file = new File(this.dir, info.fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected PresetInfo load0(@Nonnull File dataFile) {
        try (FileReader in = new FileReader(dataFile);){
            Gson gson = new GsonBuilder().create();
            PresetDataFile dataOnDisk = (PresetDataFile)gson.fromJson((Reader)in, PresetDataFile.class);
            PresetInfo presetInfo = new PresetInfo(dataFile.getName()).set(dataOnDisk);
            return presetInfo;
        }
        catch (Throwable t) {
            Presets.log().error("Unable to load data " + dataFile.getName(), t);
            return null;
        }
    }

    @Nonnull
    protected PresetInfo save0(@Nonnull PresetInfo info) {
        try {
            File dataFile = new File(this.dir, info.getFilename());
            try (FileWriter out = new FileWriter(dataFile);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                gson.toJson((Object)new PresetDataFile(info), (Appendable)out);
            }
        }
        catch (Throwable t) {
            Presets.log().error("Unable to save data " + info.getFilename(), t);
        }
        return info;
    }
}

