/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.Presets.api.events;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.blockartistry.Presets.api.PresetData;

public class PresetEvent
extends Event {
    protected final Map<String, PresetData> data;

    protected PresetEvent(@Nonnull Map<String, PresetData> data) {
        this.data = data;
    }

    @Nonnull
    public Map<String, PresetData> getData() {
        return ImmutableMap.copyOf(this.data);
    }

    @Nullable
    public PresetData getModData(@Nonnull String modId) {
        return this.data.get(modId);
    }

    public static class Save
    extends PresetEvent {
        public Save() {
            super(new HashMap<String, PresetData>());
        }

        @Override
        @Nonnull
        public PresetData getModData(@Nonnull String modId) {
            PresetData result = super.getModData(modId);
            if (result == null) {
                result = new PresetData();
                this.data.put(modId, result);
            }
            return result;
        }
    }

    public static class Load
    extends PresetEvent {
        public Load(@Nonnull Map<String, PresetData> data) {
            super(data);
        }
    }
}

