/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.Presets.api;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.Presets.api.Utils;

public final class PresetData {
    public static final char SPLIT_NEWLINE_CHAR = '\n';
    public static final char SPLIT_SPACE_CHAR = ' ';
    private final Map<String, String> data;
    private boolean restartRequired = false;

    public PresetData() {
        this.data = Maps.newHashMap();
    }

    public PresetData(@Nonnull Map<String, String> data) {
        this.data = data;
    }

    public PresetData restartRequired() {
        this.restartRequired = true;
        return this;
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    public PresetData setInt(@Nonnull String id, int value) {
        this.data.put(id, Integer.toString(value));
        return this;
    }

    public PresetData setIntList(@Nonnull String id, @Nonnull int[] values) {
        String result = StringUtils.join((Object[])Utils.toStringArray(values), (char)' ');
        this.setString(id, result);
        return this;
    }

    public PresetData setBoolean(@Nonnull String id, boolean value) {
        this.data.put(id, Boolean.toString(value));
        return this;
    }

    public PresetData setBooleanList(@Nonnull String id, @Nonnull boolean[] values) {
        String result = StringUtils.join((Object[])Utils.toStringArray(values), (char)' ');
        this.setString(id, result);
        return this;
    }

    public PresetData setDouble(@Nonnull String id, double value) {
        this.data.put(id, Double.toString(value));
        return this;
    }

    public PresetData setDoubleList(@Nonnull String id, @Nonnull double[] values) {
        String result = StringUtils.join((Object[])Utils.toStringArray(values), (char)' ');
        this.setString(id, result);
        return this;
    }

    public PresetData setString(@Nonnull String id, String value) {
        this.data.put(id, value);
        return this;
    }

    public PresetData setStringList(@Nonnull String id, @Nonnull String[] values, char splitChar) {
        this.setString(id, StringUtils.join((Object[])values, (char)splitChar));
        return this;
    }

    public int getInt(@Nonnull String id, int def) {
        if (this.data.containsKey(id)) {
            return Integer.parseInt(this.data.get(id));
        }
        return def;
    }

    public int[] getIntList(@Nonnull String id, @Nullable int[] def) {
        if (this.data.containsKey(id)) {
            return Utils.toIntArray(StringUtils.split((String)this.data.get(id), (char)' '));
        }
        return def;
    }

    public boolean getBoolean(@Nonnull String id, boolean def) {
        if (this.data.containsKey(id)) {
            return Boolean.parseBoolean(this.data.get(id));
        }
        return def;
    }

    public boolean[] getBooleanList(@Nonnull String id, @Nullable boolean[] def) {
        if (this.data.containsKey(id)) {
            return Utils.toBooleanArray(StringUtils.split((String)this.data.get(id), (char)' '));
        }
        return def;
    }

    public double getDouble(@Nonnull String id, double def) {
        if (this.data.containsKey(id)) {
            return Double.parseDouble(this.data.get(id));
        }
        return def;
    }

    public double[] getDoubleList(@Nonnull String id, @Nullable double[] def) {
        if (this.data.containsKey(id)) {
            return Utils.toDoubleArray(StringUtils.split((String)this.data.get(id), (char)' '));
        }
        return def;
    }

    @Nullable
    public String getString(@Nonnull String id, @Nullable String def) {
        if (this.data.containsKey(id)) {
            return this.data.get(id);
        }
        return def;
    }

    public String[] getStringList(@Nonnull String id, @Nullable String[] def, char splitChar) {
        if (this.data.containsKey(id)) {
            return StringUtils.split((String)this.data.get(id), (char)splitChar);
        }
        return def;
    }

    public boolean contains(@Nonnull String id) {
        return this.data.containsKey(id);
    }

    @Nonnull
    public Set<Map.Entry<String, String>> getEntries() {
        return ImmutableSet.copyOf(this.data.entrySet());
    }
}

