/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.Presets;

import java.io.File;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.profiler.Profiler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.blockartistry.Presets.ModOptions;
import org.blockartistry.Presets.proxy.Proxy;
import org.blockartistry.lib.ForgeUtils;
import org.blockartistry.lib.Localization;
import org.blockartistry.lib.VersionChecker;
import org.blockartistry.lib.logging.ModLog;

@Mod(modid="presets", useMetadata=true, dependencies="", version="3.4.9.17", acceptedMinecraftVersions="[1.10.2]", guiFactory="org.blockartistry.Presets.gui.ConfigGuiFactory", updateJSON="https://raw.githubusercontent.com/OreCruncher/DynamicSurroundings/master/version.json", clientSideOnly=true)
public class Presets {
    public static final String MOD_ID = "presets";
    public static final String API_ID = "presetsAPI";
    public static final String RESOURCE_ID = "presets";
    public static final String MOD_NAME = "Presets";
    public static final String VERSION = "3.4.9.17";
    public static final String MINECRAFT_VERSIONS = "[1.10.2]";
    public static final String DEPENDENCIES = "";
    public static final String GUI_FACTORY = "org.blockartistry.Presets.gui.ConfigGuiFactory";
    public static final String UPDATE_URL = "https://raw.githubusercontent.com/OreCruncher/DynamicSurroundings/master/version.json";
    @Mod.Instance(value="presets")
    protected static Presets instance;
    @SidedProxy(clientSide="org.blockartistry.Presets.proxy.ProxyClient", serverSide="org.blockartistry.Presets.proxy.Proxy")
    protected static Proxy proxy;
    protected static ModLog logger;
    protected static Configuration config;
    protected static File dataDirectory;

    @Nonnull
    public static Presets instance() {
        return instance;
    }

    @Nonnull
    public static Proxy proxy() {
        return proxy;
    }

    @Nonnull
    public static Configuration config() {
        return config;
    }

    @Nonnull
    public static ModLog log() {
        return logger;
    }

    @Nonnull
    public static File dataDirectory() {
        return dataDirectory;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public static Profiler getProfiler() {
        return Minecraft.func_71410_x().field_71424_I;
    }

    public Presets() {
        logger = ModLog.setLogger("presets", LogManager.getLogger((String)"presets"));
    }

    @Mod.EventHandler
    public void preInit(@Nonnull FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        dataDirectory = new File(event.getModConfigurationDirectory(), "presets");
        dataDirectory.mkdirs();
        config = new Configuration(new File(dataDirectory, "presets.cfg"), VERSION);
        config.load();
        ModOptions.load(config);
        config.save();
        logger.setDebug(ModOptions.logging.enableDebugLogging);
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(@Nonnull FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(@Nonnull FMLPostInitializationEvent event) {
        ModMetadata data;
        proxy.postInit(event);
        config.save();
        if (!proxy.isRunningAsServer() && (data = ForgeUtils.getModMetadata("presets")) != null) {
            data.name = Localization.format("presets.metadata.Name", new Object[0]);
            data.credits = Localization.format("presets.metadata.Credits", new Object[0]);
            data.description = Localization.format("presets.metadata.Description", new Object[0]);
            data.authorList = Arrays.asList(StringUtils.split((String)Localization.format("presets.metadata.Authors", new Object[0]), (char)','));
        }
    }

    @Mod.EventHandler
    public void loadCompleted(@Nonnull FMLLoadCompleteEvent event) {
        proxy.loadCompleted(event);
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (ModOptions.logging.enableVersionChecking) {
            new VersionChecker("presets", "msg.NewVersion.presets").playerLogin(event);
        }
    }

    static {
        logger = ModLog.NULL_LOGGER;
    }
}

